/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import org.apache.commons.lang.SerializationUtils;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.transport.MessageAdapter;
import org.mule.transport.AbstractMessageAdapterTestCase;
import org.mule.transport.http.HttpMessageAdapter;
import org.mule.util.store.DeserializationPostInitialisable;

public class HttpMessageAdapterTestCase
extends AbstractMessageAdapterTestCase {
    private byte[] message = "Test Message".getBytes();

    public Object getValidMessage() throws Exception {
        return this.message;
    }

    public MessageAdapter createAdapter(Object payload) throws MuleException {
        return new HttpMessageAdapter(payload);
    }

    public void testStringPayloadSerialization() throws Exception {
        String payload = "TEST";
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new HttpMessageAdapter((Object)payload), muleContext);
        byte[] serialized = SerializationUtils.serialize((Serializable)message);
        MuleMessage deserializedMessage = (MuleMessage)SerializationUtils.deserialize((byte[])serialized);
        DeserializationPostInitialisable.Implementation.init((Object)deserializedMessage, (MuleContext)muleContext);
        HttpMessageAdapterTestCase.assertEquals((String)payload, (String)deserializedMessage.getPayloadAsString());
        HttpMessageAdapterTestCase.assertEquals((String)payload, (String)message.getPayloadAsString());
    }

    public void testStreamPayloadSerialization() throws Exception {
        String payload = "TEST";
        ByteArrayInputStream stream = new ByteArrayInputStream(payload.getBytes());
        HttpMessageAdapter messageAdapter = new HttpMessageAdapter((Object)stream);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)messageAdapter, muleContext);
        byte[] serialized = SerializationUtils.serialize((Serializable)message);
        MuleMessage deserializedMessage = (MuleMessage)SerializationUtils.deserialize((byte[])serialized);
        DeserializationPostInitialisable.Implementation.init((Object)deserializedMessage, (MuleContext)muleContext);
        HttpMessageAdapterTestCase.assertEquals((String)payload, (String)deserializedMessage.getPayloadAsString());
        HttpMessageAdapterTestCase.assertEquals((String)payload, (String)message.getPayloadAsString());
    }
}

