/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.InputStream;
import java.io.NotSerializableException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.NameValuePair;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.transport.MessageAdapter;
import org.mule.transport.AbstractMessageAdapter;
import org.mule.transport.MessageAdapterSerialization;
import org.mule.transport.http.HttpResponse;
import org.mule.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMessageAdapter
extends AbstractMessageAdapter
implements MessageAdapterSerialization {
    private static final long serialVersionUID = -1544495479333000422L;
    protected boolean http11 = true;
    protected Object message;

    public HttpMessageAdapter(Object message) {
        NameValuePair param;
        Header contentTypeHeader;
        HeaderElement[] values;
        if (message instanceof Object[]) {
            Object[] messageParts = (Object[])message;
            this.message = messageParts[0];
            HashMap<Object, Object> headers = new HashMap<Object, Object>();
            if (messageParts.length > 1) {
                Object second = messageParts[1];
                if (second instanceof Map) {
                    this.setupHeadersFromMap(headers, (Map)second);
                } else if (second instanceof Header[]) {
                    this.setupHeadersFromHeaderArray(headers, (Header[])second);
                }
                this.determineHttpVersion(headers);
                this.rewriteConnectionAndKeepAliveHeaders(headers);
                this.addInboundProperties(headers);
            }
        } else {
            if (message instanceof HttpResponse) {
                this.message = message;
                return;
            }
            this.message = message;
        }
        String contentType = this.getStringProperty("Content-Type", null);
        if (contentType != null && (values = (contentTypeHeader = new Header("Content-Type", contentType)).getElements()).length == 1 && (param = values[0].getParameterByName("charset")) != null) {
            this.setEncoding(param.getValue());
        }
    }

    private void setupHeadersFromMap(Map<Object, Object> headers, Map props) {
        for (Map.Entry e : props.entrySet()) {
            String key = (String)e.getKey();
            Object value = e.getValue();
            if (value == null) continue;
            headers.put(key, value);
        }
    }

    private void setupHeadersFromHeaderArray(Map<Object, Object> headers, Header[] inboundHeaders) {
        for (int i = 0; i < inboundHeaders.length; ++i) {
            headers.put(inboundHeaders[i].getName(), inboundHeaders[i].getValue());
        }
    }

    private void determineHttpVersion(Map headers) {
        String httpVersion = (String)headers.get("http.version");
        if ("HTTP/1.0".equalsIgnoreCase(httpVersion)) {
            this.http11 = false;
        }
    }

    private void rewriteConnectionAndKeepAliveHeaders(Map<Object, Object> headers) {
        String connection;
        String headerValue = null;
        headerValue = !this.http11 ? ((connection = (String)headers.get("Connection")) != null && connection.equalsIgnoreCase("close") ? "false" : "true") : (headers.get("Connection") != null ? "true" : "false");
        headers.put("Connection", headerValue);
        headers.put("Keep-Alive", headerValue);
    }

    protected HttpMessageAdapter(HttpMessageAdapter template) {
        super((MessageAdapter)template);
        this.message = template.message;
        this.http11 = template.http11;
    }

    public Object getPayload() {
        return this.message;
    }

    @Deprecated
    public Header getHeader(String name) {
        String value = this.getStringProperty(name, null);
        if (value == null) {
            return null;
        }
        return new Header(name, value);
    }

    public ThreadSafeAccess newThreadCopy() {
        return new HttpMessageAdapter(this);
    }

    public byte[] getPayloadForSerialization() throws Exception {
        if (this.message instanceof InputStream) {
            byte[] bytes = IOUtils.toByteArray((InputStream)((InputStream)this.message));
            this.message = bytes;
            return bytes;
        }
        if (this.message instanceof byte[]) {
            return (byte[])this.message;
        }
        if (this.message instanceof String) {
            return ((String)this.message).getBytes();
        }
        throw new NotSerializableException("Don't know how to serialize payload of type " + this.message.getClass().getName());
    }
}

