/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mule.module.client.MuleClient;
import org.mule.transport.http.functional.AbstractMockHttpServerTestCase;
import org.mule.transport.http.functional.MockHttpServer;

public class HttpCookieTestCase
extends AbstractMockHttpServerTestCase {
    private static final int LISTEN_PORT = 60212;
    private static final String COOKIE_HEADER = "Cookie:";
    private CountDownLatch latch = new CountDownLatch(1);
    private boolean cookieFound = false;
    private List<String> cookieHeaders = new ArrayList<String>();

    protected String getConfigResources() {
        return "http-cookie-test.xml";
    }

    protected MockHttpServer getHttpServer(CountDownLatch serverStartLatch) {
        return new SimpleHttpServer(60212, serverStartLatch, this.latch);
    }

    public void testCookies() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("COOKIE_HEADER", "MYCOOKIE");
        MuleClient client = new MuleClient();
        client.send("vm://vm-in", (Object)"foobar", properties);
        HttpCookieTestCase.assertTrue((boolean)this.latch.await(5000L, TimeUnit.MILLISECONDS));
        HttpCookieTestCase.assertTrue((boolean)this.cookieFound);
        HttpCookieTestCase.assertTrue((this.cookieHeaders.size() == 2 ? 1 : 0) != 0);
        HttpCookieTestCase.assertEquals((String)"Cookie: $Version=0; customCookie=yes", (String)this.cookieHeaders.get(0));
        HttpCookieTestCase.assertEquals((String)"Cookie: $Version=0; expressionCookie=MYCOOKIE", (String)this.cookieHeaders.get(1));
    }

    private class SimpleHttpServer
    extends MockHttpServer {
        public SimpleHttpServer(int listenPort, CountDownLatch startupLatch, CountDownLatch testCompleteLatch) {
            super(listenPort, startupLatch, testCompleteLatch);
        }

        protected void readHttpRequest(BufferedReader reader) throws Exception {
            String line = reader.readLine();
            while (line != null) {
                if (line.indexOf(HttpCookieTestCase.COOKIE_HEADER) > -1) {
                    HttpCookieTestCase.this.cookieFound = true;
                    HttpCookieTestCase.this.cookieHeaders.add(line);
                }
                if ((line = reader.readLine()).trim().length() != 0) continue;
                line = null;
            }
        }
    }
}

