/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.HashMap;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.transport.http.functional.HttpFunctionalTestCase;

public class HttpEncodingFunctionalTestCase
extends HttpFunctionalTestCase {
    protected static String TEST_MESSAGE = "Test Http Request (R\u00ef\u00bf\u00bddgr\u00ef\u00bf\u00bdd), 57 = \u06f7\u06f5 in Arabic";

    protected String getConfigResources() {
        return "http-encoding-test.xml";
    }

    public void testSend() throws Exception {
        MuleClient client = new MuleClient();
        HashMap<String, String> messageProperties = new HashMap<String, String>();
        messageProperties.put("Content-Type", this.getSendEncoding());
        MuleMessage reply = client.send("clientEndpoint", (Object)TEST_MESSAGE, messageProperties);
        HttpEncodingFunctionalTestCase.assertNotNull((Object)reply);
        HttpEncodingFunctionalTestCase.assertEquals((Object)"200", (Object)reply.getProperty("http.status"));
        HttpEncodingFunctionalTestCase.assertEquals((String)"text/baz;charset=UTF-16BE", (String)reply.getProperty("Content-Type").toString());
        HttpEncodingFunctionalTestCase.assertEquals((String)"UTF-16BE", (String)reply.getEncoding());
        HttpEncodingFunctionalTestCase.assertEquals((String)(TEST_MESSAGE + " Received"), (String)reply.getPayloadAsString());
    }

    protected String getSendEncoding() {
        return "text/plain;charset=UTF-8";
    }
}

