/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public abstract class MockHttpServer
implements Runnable {
    private int listenPort;
    private CountDownLatch startupLatch;
    private CountDownLatch testCompleteLatch;

    public MockHttpServer(int listenPort, CountDownLatch startupLatch, CountDownLatch testCompleteLatch) {
        this.listenPort = listenPort;
        this.startupLatch = startupLatch;
        this.testCompleteLatch = testCompleteLatch;
    }

    protected abstract void readHttpRequest(BufferedReader var1) throws Exception;

    public void run() {
        try {
            ServerSocket serverSocket = new ServerSocket(this.listenPort);
            this.startupLatch.countDown();
            Socket socket = serverSocket.accept();
            InputStream in = socket.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            this.readHttpRequest(reader);
            OutputStream out = socket.getOutputStream();
            out.write("HTTP/1.1 200 OK\n\n".getBytes());
            in.close();
            out.close();
            socket.close();
            serverSocket.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.testCompleteLatch.countDown();
        }
    }
}

