/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.issues;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;

public class HttpMessageReceiverMule4456TestCase
extends FunctionalTestCase {
    private static final String MESSAGE = "test message";
    private HttpClient httpClient;
    private MuleClient muleClient;

    protected boolean isGracefulShutdown() {
        return true;
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        HttpClientParams params = new HttpClientParams();
        params.setVersion(HttpVersion.HTTP_1_1);
        this.httpClient = new HttpClient(params);
        this.muleClient = new MuleClient();
    }

    protected String getConfigResources() {
        return "http-receiver-mule4456-config.xml";
    }

    public void testAsyncPost() throws Exception {
        FunctionalTestComponent component = (FunctionalTestComponent)this.getComponent("AsyncService");
        component.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object comp) throws Exception {
                Thread.sleep(200L);
                context.getMessageAsString();
            }
        });
        PostMethod request = new PostMethod("http://localhost:60217");
        StringRequestEntity entity = new StringRequestEntity(MESSAGE, "text/plain", muleContext.getConfiguration().getDefaultEncoding());
        request.setRequestEntity((RequestEntity)entity);
        this.httpClient.executeMethod((HttpMethod)request);
        MuleMessage message = this.muleClient.request("vm://out", 1000L);
        HttpMessageReceiverMule4456TestCase.assertNotNull((Object)message);
        HttpMessageReceiverMule4456TestCase.assertEquals((String)MESSAGE, (String)message.getPayloadAsString());
    }

    public void testAsyncPostWithPersistentSedaQueue() throws Exception {
        FunctionalTestComponent component = (FunctionalTestComponent)this.getComponent("AsyncPersistentQueueService");
        component.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object comp) throws Exception {
                Thread.sleep(200L);
                context.getMessageAsString();
            }
        });
        PostMethod request = new PostMethod("http://localhost:60218");
        StringRequestEntity entity = new StringRequestEntity(MESSAGE, "text/plain", muleContext.getConfiguration().getDefaultEncoding());
        request.setRequestEntity((RequestEntity)entity);
        this.httpClient.executeMethod((HttpMethod)request);
        MuleMessage message = this.muleClient.request("vm://out", 1000L);
        HttpMessageReceiverMule4456TestCase.assertNotNull((Object)message);
        HttpMessageReceiverMule4456TestCase.assertEquals((String)MESSAGE, (String)message.getPayloadAsString());
    }
}

