/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.transport.AbstractConnectorTestCase;
import org.mule.transport.http.HttpConnector;

public class HttpConnectorTestCase
extends AbstractConnectorTestCase {
    public Connector createConnector() throws Exception {
        HttpConnector c = new HttpConnector(muleContext);
        c.setName("HttpConnector");
        return c;
    }

    public String getTestEndpointURI() {
        return "http://localhost:60127";
    }

    public Object getValidMessage() throws Exception {
        return "Hello".getBytes();
    }

    public void testValidListener() throws Exception {
        Service service = HttpConnectorTestCase.getTestService((String)"orange", Orange.class);
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint(this.getTestEndpointURI());
        this.getConnector().registerListener(endpoint, (MessageProcessor)this.getNullMessageProcessor(), (FlowConstruct)service);
    }

    public void testProperties() throws Exception {
        HttpConnector c = (HttpConnector)this.getConnector();
        c.setSendBufferSize(1024);
        HttpConnectorTestCase.assertEquals((int)1024, (int)c.getSendBufferSize());
        c.setSendBufferSize(0);
        HttpConnectorTestCase.assertEquals((int)-1, (int)c.getSendBufferSize());
        int maxDispatchers = c.getMaxTotalDispatchers();
        HttpConnectionManagerParams params = c.getClientConnectionManager().getParams();
        HttpConnectorTestCase.assertEquals((int)maxDispatchers, (int)params.getDefaultMaxConnectionsPerHost());
        HttpConnectorTestCase.assertEquals((int)maxDispatchers, (int)params.getMaxTotalConnections());
    }
}

