/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import com.mockobjects.dynamic.Mock;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.Map;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.SSLSocket;
import javax.resource.spi.work.Work;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.routing.inbound.DefaultInboundRouterCollection;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transport.http.HttpsConnector;
import org.mule.transport.http.HttpsMessageReceiver;
import org.mule.transport.ssl.MockHandshakeCompletedEvent;
import org.mule.transport.ssl.MockSslSocket;

public class HttpsHandshakeTimingTestCase
extends AbstractMuleTestCase {
    public void testHttpsHandshakeExceedsTimeout() throws Exception {
        MockHttpsMessageReceiver messageReceiver = this.setupMockHttpsMessageReceiver();
        MockSslSocket socket = new MockSslSocket();
        Work work = messageReceiver.createWork((Socket)socket);
        HttpsHandshakeTimingTestCase.assertNotNull((Object)work);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        try {
            this.invokePreRouteMessage(work, (MuleMessage)message);
            HttpsHandshakeTimingTestCase.fail();
        }
        catch (InvocationTargetException ite) {
            HttpsHandshakeTimingTestCase.assertTrue((boolean)(ite.getCause() instanceof MessagingException));
            HttpsHandshakeTimingTestCase.assertTrue((boolean)ite.getCause().getMessage().contains("handshake"));
        }
    }

    public void testHttpsHandshakeCompletesBeforeProcessingMessage() throws Exception {
        MockHttpsMessageReceiver messageReceiver = this.setupMockHttpsMessageReceiver();
        MockSslSocket socket = new MockSslSocket();
        Work work = messageReceiver.createWork((Socket)socket);
        HttpsHandshakeTimingTestCase.assertNotNull((Object)work);
        this.invokeHandshakeCompleted(work, socket);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        this.invokePreRouteMessage(work, (MuleMessage)message);
        HttpsHandshakeTimingTestCase.assertNotNull((Object)message.getProperty("MULE_REMOTE_CLIENT_ADDRESS"));
    }

    private void invokeHandshakeCompleted(Work work, MockSslSocket socket) throws Exception {
        Method handshakeCompleted = work.getClass().getDeclaredMethod("handshakeCompleted", HandshakeCompletedEvent.class);
        HttpsHandshakeTimingTestCase.assertNotNull((Object)handshakeCompleted);
        handshakeCompleted.setAccessible(true);
        MockHandshakeCompletedEvent event = new MockHandshakeCompletedEvent((SSLSocket)socket);
        handshakeCompleted.invoke((Object)work, event);
    }

    private void invokePreRouteMessage(Work work, MuleMessage message) throws Exception {
        Method preRouteMessage = work.getClass().getDeclaredMethod("preRouteMessage", MuleMessage.class);
        HttpsHandshakeTimingTestCase.assertNotNull((Object)preRouteMessage);
        preRouteMessage.setAccessible(true);
        preRouteMessage.invoke((Object)work, message);
    }

    private MockHttpsMessageReceiver setupMockHttpsMessageReceiver() throws CreateException {
        HttpsConnector httpsConnector = new HttpsConnector(muleContext);
        httpsConnector.setSslHandshakeTimeout(1000L);
        Map properties = Collections.emptyMap();
        Mock mockEndpoint = new Mock(InboundEndpoint.class);
        mockEndpoint.expectAndReturn("getConnector", (Object)httpsConnector);
        mockEndpoint.expectAndReturn("getEncoding", (Object)new DefaultMuleConfiguration().getDefaultEncoding());
        mockEndpoint.expectAndReturn("getProperties", (Object)properties);
        mockEndpoint.expectAndReturn("getProperties", (Object)properties);
        InboundEndpoint inboundEndpoint = (InboundEndpoint)mockEndpoint.proxy();
        Mock mockService = new Mock(Service.class);
        mockService.expectAndReturn("getResponseRouter", null);
        mockService.expectAndReturn("getInboundRouter", (Object)new DefaultInboundRouterCollection());
        Service service = (Service)mockService.proxy();
        MockHttpsMessageReceiver messageReceiver = new MockHttpsMessageReceiver((Connector)httpsConnector, service, inboundEndpoint);
        return messageReceiver;
    }

    private static class MockHttpsMessageReceiver
    extends HttpsMessageReceiver {
        public MockHttpsMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint) throws CreateException {
            super(connector, service, endpoint);
        }

        public Work createWork(Socket socket) throws IOException {
            return super.createWork(socket);
        }
    }
}

