/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.transport.MessageTypeNotSupportedException;
import org.mule.transport.AbstractMuleMessageFactory;
import org.mule.transport.http.CookieHelper;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.ReleasingInputStream;
import org.mule.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMuleMessageFactory
extends AbstractMuleMessageFactory {
    private static Log log = LogFactory.getLog(HttpMuleMessageFactory.class);
    private boolean enableCookies = false;
    private String cookieSpec = null;
    private boolean synchronous = true;

    public HttpMuleMessageFactory(MuleContext context) {
        super(context);
    }

    protected Class<?>[] getSupportedTransportMessageTypes() {
        return new Class[]{HttpRequest.class, HttpMethod.class};
    }

    protected Object extractPayload(Object transportMessage, String encoding) throws Exception {
        if (transportMessage instanceof HttpRequest) {
            return this.extractPayloadFromHttpRequest((HttpRequest)transportMessage);
        }
        if (transportMessage instanceof HttpMethod) {
            return this.extractPayloadFromHttpMethod((HttpMethod)transportMessage);
        }
        throw new MessageTypeNotSupportedException(transportMessage, ((Object)((Object)this)).getClass());
    }

    protected Object extractPayloadFromHttpRequest(HttpRequest httpRequest) throws IOException {
        Object body = httpRequest.getBody();
        if (body == null) {
            body = httpRequest.getRequestLine().getUri();
        } else if (!this.synchronous) {
            log.debug((Object)"Reading HTTP POST InputStream into byte[] for asynchronous messaging.");
            body = IOUtils.toByteArray((InputStream)((InputStream)body));
        }
        return body;
    }

    protected Object extractPayloadFromHttpMethod(HttpMethod httpMethod) throws IOException {
        InputStream body = httpMethod.getResponseBodyAsStream();
        if (body != null) {
            return new ReleasingInputStream(body, httpMethod);
        }
        return "";
    }

    protected void addProperties(DefaultMuleMessage message, Object transportMessage) throws Exception {
        Header cookieHeader;
        Map<String, Object> headers;
        String uri;
        HttpVersion httpVersion;
        String method;
        String statusCode = null;
        if (transportMessage instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)transportMessage;
            method = httpRequest.getRequestLine().getMethod();
            httpVersion = httpRequest.getRequestLine().getHttpVersion();
            uri = httpRequest.getRequestLine().getUri();
            headers = this.convertHeadersToMap(httpRequest.getHeaders());
            cookieHeader = httpRequest.getFirstHeader("cookies");
        } else if (transportMessage instanceof HttpMethod) {
            HttpMethod httpMethod = (HttpMethod)transportMessage;
            method = httpMethod.getName();
            httpVersion = HttpVersion.parse((String)httpMethod.getStatusLine().getHttpVersion());
            uri = httpMethod.getURI().toString();
            statusCode = String.valueOf(httpMethod.getStatusCode());
            headers = this.convertHeadersToMap(httpMethod.getResponseHeaders());
            cookieHeader = httpMethod.getResponseHeader("cookies");
        } else {
            throw new MessageTypeNotSupportedException(transportMessage, ((Object)((Object)this)).getClass());
        }
        this.rewriteConnectionAndKeepAliveHeaders(headers);
        headers = this.processIncomingHeaders(headers, uri, cookieHeader);
        headers.put("http.method", method);
        headers.put("http.request", uri);
        headers.put("http.version", httpVersion.toString());
        if (this.enableCookies) {
            headers.put("cookieSpec", this.cookieSpec);
        }
        if (statusCode != null) {
            headers.put("http.status", statusCode);
        }
        if (transportMessage instanceof HttpRequest) {
            message.addInboundProperties(headers);
        } else {
            message.addProperties(headers);
        }
        this.initEncoding((MuleMessage)message, headers);
    }

    protected Map<String, Object> processIncomingHeaders(Map<String, Object> headers, String uri, Header cookieHeader) throws Exception {
        HashMap<String, Object> outHeaders = new HashMap<String, Object>();
        for (String headerName : headers.keySet()) {
            Cookie[] headerValue = headers.get(headerName);
            if (headerName.startsWith("X-MULE")) {
                headerName = headerName.substring(2);
            } else if (headerName.equals("cookies")) {
                URI u;
                CookieSpec cs;
                Cookie[] cookies;
                if (!this.enableCookies || (cookies = (cs = CookieHelper.getCookieSpec(this.cookieSpec)).parse((u = new URI(uri)).getHost(), u.getPort(), u.getPath(), u.getScheme().equalsIgnoreCase("https"), cookieHeader)).length <= 0) continue;
                headerValue = cookies;
            }
            outHeaders.put(headerName, headerValue);
        }
        return outHeaders;
    }

    private Map<String, Object> convertHeadersToMap(Header[] headers) {
        HashMap<String, Object> headersMap = new HashMap<String, Object>();
        for (int i = 0; i < headers.length; ++i) {
            headersMap.put(headers[i].getName(), headers[i].getValue());
        }
        return headersMap;
    }

    private void initEncoding(MuleMessage message, Map<String, Object> headers) {
        NameValuePair param;
        Header contentTypeHeader;
        HeaderElement[] values;
        Object contentType = headers.get("Content-Type");
        if (contentType != null && (values = (contentTypeHeader = new Header("Content-Type", contentType.toString())).getElements()).length == 1 && (param = values[0].getParameterByName("charset")) != null) {
            message.setEncoding(param.getValue());
        }
    }

    private void rewriteConnectionAndKeepAliveHeaders(Map<String, Object> headers) {
        String connection;
        String headerValue = null;
        headerValue = !this.isHttp11(headers) ? ((connection = (String)headers.get("Connection")) != null && connection.equalsIgnoreCase("close") ? "false" : "true") : (headers.get("Connection") != null ? "true" : "false");
        headers.put("Connection", headerValue);
        headers.put("Keep-Alive", headerValue);
    }

    private boolean isHttp11(Map<String, Object> headers) {
        String httpVersion = (String)headers.get("http.version");
        return !"HTTP/1.0".equalsIgnoreCase(httpVersion);
    }

    public void setEnableCookies(boolean enableCookies) {
        this.enableCookies = enableCookies;
    }

    public void setCookieSpec(String cookieSpec) {
        this.cookieSpec = cookieSpec;
    }

    public void setSynchronous(boolean flag) {
        this.synchronous = flag;
    }
}

