/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.model.SessionException;
import org.mule.api.transport.SessionHandler;
import org.mule.config.i18n.MessageFactory;
import org.mule.util.Base64;

public class HttpSessionHandler
implements SessionHandler {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    public MuleSession retrieveSessionInfoFromMessage(MuleMessage message) throws MuleException {
        byte[] serializedSession;
        MuleSession session = null;
        Cookie[] cookies = (Cookie[])message.getProperty("cookies");
        if (cookies != null && cookies.length > 0 && (serializedSession = Base64.decode((String)cookies[0].getValue())) != null) {
            session = (MuleSession)SerializationUtils.deserialize((byte[])serializedSession);
        }
        return session;
    }

    public void retrieveSessionInfoFromMessage(MuleMessage message, MuleSession session) throws MuleException {
        session = this.retrieveSessionInfoFromMessage(message);
    }

    public void storeSessionInfoToMessage(MuleSession session, MuleMessage message) throws MuleException {
        String serializedEncodedSession;
        byte[] serializedSession = SerializationUtils.serialize((Serializable)session);
        try {
            serializedEncodedSession = Base64.encodeBytes((byte[])serializedSession, (int)8);
        }
        catch (IOException e) {
            throw new SessionException(MessageFactory.createStaticMessage((String)"Unable to serialize MuleSession"), (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding serialized and base64-encoded Session header to message: " + serializedEncodedSession));
        }
        message.setProperty("cookies", (Object)new Cookie[]{new Cookie(null, "MULE_SESSION", serializedEncodedSession)});
    }

    public String getSessionIDKey() {
        return "ID";
    }
}

