/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.util.Collections;
import java.util.Map;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.DefaultMuleSession;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.http.HttpPollingConnector;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.util.MapUtils;

public class PollingHttpMessageReceiver
extends AbstractPollingMessageReceiver {
    protected String etag = null;
    private boolean checkEtag;
    private boolean discardEmptyContent;
    private OutboundEndpoint outboundEndpoint;

    public PollingHttpMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
        if (!(connector instanceof HttpPollingConnector)) {
            throw new CreateException(HttpMessages.pollingReciverCannotbeUsed(), (Object)this);
        }
        HttpPollingConnector pollingConnector = (HttpPollingConnector)connector;
        long pollingFrequency = MapUtils.getLongValue((Map)endpoint.getProperties(), (Object)"pollingFrequency", (long)pollingConnector.getPollingFrequency());
        if (pollingFrequency > 0L) {
            this.setFrequency(pollingFrequency);
        }
        this.checkEtag = MapUtils.getBooleanValue((Map)endpoint.getProperties(), (Object)"checkEtag", (boolean)pollingConnector.isCheckEtag());
        this.discardEmptyContent = MapUtils.getBooleanValue((Map)endpoint.getProperties(), (Object)"discardEmptyContent", (boolean)pollingConnector.isDiscardEmptyContent());
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    public void doDisconnect() throws Exception {
    }

    public void poll() throws Exception {
        MuleContext muleContext = this.connector.getMuleContext();
        DefaultMuleMessage request = new DefaultMuleMessage((Object)"", muleContext);
        if (this.etag != null && this.checkEtag) {
            Map<String, String> customHeaders = Collections.singletonMap("If-None-Match", this.etag);
            request.setProperty("http.custom.headers", customHeaders);
        }
        request.setProperty("http.method", (Object)"GET");
        DefaultMuleSession session = new DefaultMuleSession((FlowConstruct)((Service)this.flowConstruct), this.connector.getMuleContext());
        if (this.outboundEndpoint == null) {
            EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(this.endpoint);
            endpointBuilder.setTransformers(Collections.EMPTY_LIST);
            endpointBuilder.setResponseTransformers(Collections.EMPTY_LIST);
            endpointBuilder.setExchangePattern(MessageExchangePattern.REQUEST_RESPONSE);
            this.outboundEndpoint = muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint((EndpointBuilder)endpointBuilder);
        }
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)request, (ImmutableEndpoint)this.outboundEndpoint, (MuleSession)session);
        MuleEvent result = this.outboundEndpoint.process((MuleEvent)event);
        MuleMessage message = null;
        if (result != null) {
            message = result.getMessage();
        }
        if (message.getIntProperty("Content-Length", -1) == 0 && this.discardEmptyContent) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Received empty message and ignoring from: " + this.endpoint.getEndpointURI()));
            }
            return;
        }
        int status = message.getIntProperty("http.status", 0);
        this.etag = message.getStringProperty("ETag", null);
        if (status != 304 || !this.checkEtag) {
            this.routeMessage(message, this.endpoint.isSynchronous());
        }
    }
}

