/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.transformers;

import java.net.URI;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageAwareTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestBodyToParamMap
extends AbstractMessageAwareTransformer {
    public HttpRequestBodyToParamMap() {
        this.registerSourceType(Object.class);
        this.setReturnDataType(DataTypeFactory.create(Object.class));
    }

    public Object transform(MuleMessage message, String encoding) throws TransformerException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            String httpMethod = (String)message.getProperty("http.method");
            String contentType = (String)message.getProperty("Content-Type");
            boolean isGet = "GET".equalsIgnoreCase(httpMethod);
            boolean isPost = "POST".equalsIgnoreCase(httpMethod);
            boolean isUrlEncoded = contentType.startsWith("application/x-www-form-urlencoded");
            if (!(isGet || isPost && isUrlEncoded)) {
                throw new Exception("The HTTP method or content type is unsupported!");
            }
            String queryString = null;
            if (isGet) {
                URI uri = new URI(message.getPayloadAsString(encoding));
                queryString = uri.getQuery();
            } else if (isPost) {
                queryString = new String(message.getPayloadAsBytes());
            }
            if (StringUtils.isNotBlank(queryString)) {
                String[] pairs;
                for (String pair : pairs = queryString.split("&")) {
                    String[] nameValue = pair.split("=");
                    if (nameValue.length != 2) continue;
                    String key = URLDecoder.decode(nameValue[0], encoding);
                    String value = URLDecoder.decode(nameValue[1], encoding);
                    this.addToParameterMap(paramMap, key, value);
                }
            }
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
        return paramMap;
    }

    private void addToParameterMap(Map<String, Object> paramMap, String key, String value) {
        Object existingValue = paramMap.get(key);
        if (existingValue != null) {
            List<Object> values = null;
            values = existingValue instanceof List ? (List<Object>)existingValue : Arrays.asList(existingValue);
            values.add(value);
            paramMap.put(key, values);
        } else {
            paramMap.put(key, value);
        }
    }

    public boolean isAcceptNull() {
        return false;
    }
}

