/*
 * $Id: HttpOutboundTestCase.java 18404 2010-07-20 20:23:50Z rossmason $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transport.http.functional;

import org.mule.module.client.MuleClient;
import org.mule.transport.http.HttpConstants;
import org.mule.util.concurrent.Latch;

import java.io.BufferedReader;
import java.util.StringTokenizer;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;

public class HttpOutboundTestCase extends AbstractMockHttpServerTestCase
{
    private static final int LISTEN_PORT = 60215;
    private Latch testLatch = new Latch();
    private String httpMethod;

    public HttpOutboundTestCase()
    {
        setDisposeManagerPerSuite(true);
    }

    protected MockHttpServer getHttpServer(CountDownLatch latch)
    {
        return new SimpleHttpServer(LISTEN_PORT, latch, testLatch);
    }

    protected String getConfigResources()
    {
        return "http-outbound-config.xml";
    }
    
    public void testOutboundDelete() throws Exception
    {
        sendHttpRequest("vm://doDelete", HttpConstants.METHOD_DELETE);
    }

    public void testOutboundGet() throws Exception
    {
        sendHttpRequest("vm://doGet", HttpConstants.METHOD_GET);
    }

    public void testOutboundHead() throws Exception
    {
        sendHttpRequest("vm://doHead", HttpConstants.METHOD_HEAD);
    }

    public void testOutboundOptions() throws Exception
    {
        sendHttpRequest("vm://doOptions", HttpConstants.METHOD_OPTIONS);
    }

    public void testOutboundPost() throws Exception
    {
        sendHttpRequest("vm://doPost", HttpConstants.METHOD_POST);
    }

    public void testOutboundPut() throws Exception
    {
        sendHttpRequest("vm://doPut", HttpConstants.METHOD_PUT);
    }

    public void testOutboundTrace() throws Exception
    {
        sendHttpRequest("vm://doTrace", HttpConstants.METHOD_TRACE);
    }

    private void sendHttpRequest(String endpoint, String expectedHttpMethod) throws Exception
    {
        MuleClient client = new MuleClient(muleContext);
        client.dispatch(endpoint, TEST_MESSAGE, null);
        
        assertTrue(testLatch.await(RECEIVE_TIMEOUT, TimeUnit.MILLISECONDS));
        assertEquals(expectedHttpMethod, httpMethod);
    }
    
    private class SimpleHttpServer extends MockHttpServer
    {
        public SimpleHttpServer(int listenPort, CountDownLatch startupLatch, CountDownLatch testCompleteLatch)
        {
            super(listenPort, startupLatch, testCompleteLatch);
        }

        @Override
        protected void readHttpRequest(BufferedReader reader) throws Exception
        {
            // first line is the HTTP request
            String line = reader.readLine();
            httpMethod = new StringTokenizer(line).nextToken();            
        }
    }
}
