/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.URI;
import org.mockito.Mockito;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleMessage;
import org.mule.api.transport.MessageTypeNotSupportedException;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.transport.AbstractMuleMessageFactoryTestCase;
import org.mule.transport.http.HttpMuleMessageFactory;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.RequestLine;

public class HttpMuleMessageFactoryTestCase
extends AbstractMuleMessageFactoryTestCase {
    private static final Header[] HEADERS = new Header[]{new Header("foo-header", "foo-value")};
    private static final String REQUEST_LINE = "GET /services/Echo HTTP/1.1";

    protected MuleMessageFactory doCreateMuleMessageFactory() {
        return new HttpMuleMessageFactory(muleContext);
    }

    protected Object getValidTransportMessage() throws Exception {
        RequestLine requestLine = RequestLine.parseLine((String)REQUEST_LINE);
        HttpRequest request = new HttpRequest(requestLine, HEADERS, null, this.encoding);
        return request;
    }

    protected Object getUnsupportedTransportMessage() {
        return "this is not a valid transport message for HttpMuleMessageFactory";
    }

    public void testValidPayload() throws Exception {
        MuleMessageFactory factory = this.createMuleMessageFactory();
        Object payload = this.getValidTransportMessage();
        MuleMessage message = factory.create(payload, this.encoding);
        HttpMuleMessageFactoryTestCase.assertNotNull((Object)message);
        HttpMuleMessageFactoryTestCase.assertEquals((Object)"/services/Echo", (Object)message.getPayload());
        HttpMuleMessageFactoryTestCase.assertEquals((Object)"GET", (Object)message.getInboundProperty("http.method"));
        HttpMuleMessageFactoryTestCase.assertEquals((Object)"foo-value", (Object)message.getInboundProperty("foo-header"));
    }

    public void testInvalidPayloadOnHttpMuleMessageFactory() throws Exception {
        HttpMuleMessageFactory factory = new HttpMuleMessageFactory(muleContext);
        try {
            factory.extractPayload(this.getUnsupportedTransportMessage(), this.encoding);
            HttpMuleMessageFactoryTestCase.fail((String)"HttpMuleMessageFactory should fail when receiving an invalid payload");
        }
        catch (MessageTypeNotSupportedException messageTypeNotSupportedException) {
            // empty catch block
        }
    }

    public void testHttpRequestPostPayload() throws Exception {
        HttpMuleMessageFactory factory = (HttpMuleMessageFactory)this.createMuleMessageFactory();
        factory.setExchangePattern(MessageExchangePattern.ONE_WAY);
        HttpRequest request = this.createPostHttpRequest();
        MuleMessage message = factory.create((Object)request, this.encoding);
        HttpMuleMessageFactoryTestCase.assertNotNull((Object)message);
        HttpMuleMessageFactoryTestCase.assertEquals(byte[].class, message.getPayload().getClass());
        byte[] payload = (byte[])message.getPayload();
        HttpMuleMessageFactoryTestCase.assertTrue((boolean)Arrays.equals("Test Message".getBytes(), payload));
    }

    private HttpRequest createPostHttpRequest() throws Exception {
        String line = REQUEST_LINE.replace("GET", "POST");
        RequestLine requestLine = RequestLine.parseLine((String)line);
        ByteArrayInputStream stream = new ByteArrayInputStream("Test Message".getBytes());
        return new HttpRequest(requestLine, HEADERS, (InputStream)stream, this.encoding);
    }

    public void testHttpMethodGet() throws Exception {
        ByteArrayInputStream body = new ByteArrayInputStream("/services/Echo".getBytes());
        HttpMethod method = this.createMockHttpMethod("GET", body);
        MuleMessageFactory factory = this.createMuleMessageFactory();
        MuleMessage message = factory.create((Object)method, this.encoding);
        HttpMuleMessageFactoryTestCase.assertNotNull((Object)message);
        HttpMuleMessageFactoryTestCase.assertEquals((String)"/services/Echo", (String)message.getPayloadAsString());
        HttpMuleMessageFactoryTestCase.assertEquals((Object)"GET", (Object)message.getInboundProperty("http.method"));
        HttpMuleMessageFactoryTestCase.assertEquals((Object)HttpVersion.HTTP_1_1.toString(), (Object)message.getInboundProperty("http.version"));
        HttpMuleMessageFactoryTestCase.assertEquals((Object)"200", (Object)message.getInboundProperty("http.status"));
    }

    public void testHttpMethodPost() throws Exception {
        ByteArrayInputStream body = new ByteArrayInputStream("Test Message".getBytes());
        HttpMethod method = this.createMockHttpMethod("POST", body);
        MuleMessageFactory factory = this.createMuleMessageFactory();
        MuleMessage message = factory.create((Object)method, this.encoding);
        HttpMuleMessageFactoryTestCase.assertNotNull((Object)message);
        HttpMuleMessageFactoryTestCase.assertEquals((String)"Test Message", (String)message.getPayloadAsString());
        HttpMuleMessageFactoryTestCase.assertEquals((Object)"POST", (Object)message.getInboundProperty("http.method"));
        HttpMuleMessageFactoryTestCase.assertEquals((Object)HttpVersion.HTTP_1_1.toString(), (Object)message.getInboundProperty("http.version"));
        HttpMuleMessageFactoryTestCase.assertEquals((Object)"200", (Object)message.getInboundProperty("http.status"));
    }

    private HttpMethod createMockHttpMethod(String method, InputStream body) throws Exception {
        HttpMethod httpMethod = (HttpMethod)Mockito.mock(HttpMethod.class);
        Mockito.when((Object)httpMethod.getName()).thenReturn((Object)method);
        Mockito.when((Object)httpMethod.getStatusLine()).thenReturn((Object)new StatusLine("HTTP/1.1 200 OK"));
        Mockito.when((Object)httpMethod.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)httpMethod.getURI()).thenReturn((Object)new URI("http://localhost/services/Echo", false));
        Mockito.when((Object)httpMethod.getResponseHeaders()).thenReturn((Object)HEADERS);
        Mockito.when((Object)httpMethod.getResponseBodyAsStream()).thenReturn((Object)body);
        return httpMethod;
    }
}

