/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.transformers;

import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.expression.RequiredValueException;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transport.NullPayload;
import org.mule.transport.http.transformers.ObjectToHttpClientMethodRequest;

public class ObjectToHttpClientMethodRequestTestCase
extends AbstractMuleTestCase {
    private MuleMessage setupRequestContext(String url) throws Exception {
        return this.setupRequestContext(url, "test");
    }

    private MuleMessage setupRequestContext(String url, String payload) throws Exception {
        MuleEvent event = ObjectToHttpClientMethodRequestTestCase.getTestEvent((Object)payload);
        MuleMessage message = event.getMessage();
        message.setOutboundProperty("http.method", (Object)"GET");
        message.setOutboundProperty("MULE_ENDPOINT", (Object)url);
        RequestContext.setEvent((MuleEvent)event);
        return message;
    }

    private ObjectToHttpClientMethodRequest createTransformer() throws Exception {
        ObjectToHttpClientMethodRequest transformer = new ObjectToHttpClientMethodRequest();
        transformer.setMuleContext(muleContext);
        transformer.initialise();
        return transformer;
    }

    protected void doTearDown() throws Exception {
        RequestContext.setEvent(null);
    }

    public void testUrlWithoutQuery() throws Exception {
        MuleMessage message = this.setupRequestContext("http://localhost:8080/services");
        message.setPayload((Object)NullPayload.getInstance());
        ObjectToHttpClientMethodRequest transformer = this.createTransformer();
        Object response = transformer.transform((Object)message);
        ObjectToHttpClientMethodRequestTestCase.assertTrue((boolean)(response instanceof HttpMethod));
        HttpMethod httpMethod = (HttpMethod)response;
        ObjectToHttpClientMethodRequestTestCase.assertEquals(null, (String)httpMethod.getQueryString());
    }

    public void testUrlWithQuery() throws Exception {
        MuleMessage message = this.setupRequestContext("http://localhost:8080/services?method=echo");
        message.setPayload((Object)NullPayload.getInstance());
        ObjectToHttpClientMethodRequest transformer = this.createTransformer();
        Object response = transformer.transform((Object)message);
        ObjectToHttpClientMethodRequestTestCase.assertTrue((boolean)(response instanceof HttpMethod));
        HttpMethod httpMethod = (HttpMethod)response;
        ObjectToHttpClientMethodRequestTestCase.assertEquals((String)"method=echo", (String)httpMethod.getQueryString());
    }

    public void testUrlWithUnescapedQuery() throws Exception {
        MuleMessage message = this.setupRequestContext("http://mycompany.com/test?fruits=apple%20orange");
        message.setPayload((Object)NullPayload.getInstance());
        ObjectToHttpClientMethodRequest transformer = this.createTransformer();
        Object response = transformer.transform((Object)message);
        ObjectToHttpClientMethodRequestTestCase.assertTrue((boolean)(response instanceof HttpMethod));
        HttpMethod httpMethod = (HttpMethod)response;
        ObjectToHttpClientMethodRequestTestCase.assertEquals((String)"fruits=apple%20orange", (String)httpMethod.getQueryString());
    }

    public void testAppendedUrl() throws Exception {
        MuleMessage message = this.setupRequestContext("http://mycompany.com/test?fruits=apple%20orange");
        message.setPayload((Object)"test");
        ObjectToHttpClientMethodRequest transformer = this.createTransformer();
        Object response = transformer.transform((Object)message);
        ObjectToHttpClientMethodRequestTestCase.assertTrue((boolean)(response instanceof HttpMethod));
        HttpMethod httpMethod = (HttpMethod)response;
        ObjectToHttpClientMethodRequestTestCase.assertEquals((String)"fruits=apple%20orange&body=test", (String)httpMethod.getQueryString());
    }

    public void testAppendedUrlWithExpressions() throws Exception {
        MuleMessage message = this.setupRequestContext("http://mycompany.com/test?fruits=#[header:fruit1],#[header:fruit2]&correlationID=#[message:correlationId]");
        message.setPayload((Object)NullPayload.getInstance());
        message.setCorrelationId("1234");
        message.setOutboundProperty("fruit1", (Object)"apple");
        message.setOutboundProperty("fruit2", (Object)"orange");
        ObjectToHttpClientMethodRequest transformer = this.createTransformer();
        Object response = transformer.transform((Object)message);
        ObjectToHttpClientMethodRequestTestCase.assertTrue((boolean)(response instanceof HttpMethod));
        HttpMethod httpMethod = (HttpMethod)response;
        ObjectToHttpClientMethodRequestTestCase.assertEquals((String)"fruits=apple,orange&correlationID=1234", (String)httpMethod.getQueryString());
    }

    public void testAppendedUrlWithBadExpressions() throws Exception {
        MuleMessage message = this.setupRequestContext("http://mycompany.com/test?param=#[foo:bar]}");
        message.setPayload((Object)NullPayload.getInstance());
        ObjectToHttpClientMethodRequest transformer = this.createTransformer();
        try {
            transformer.transform((Object)message);
            ObjectToHttpClientMethodRequestTestCase.fail((String)"unknown evaluator was used");
        }
        catch (TransformerException e) {
            ObjectToHttpClientMethodRequestTestCase.assertTrue((boolean)e.getMessage().contains("Evaluator for \"foo\" is not registered with Mule"));
        }
        message = this.setupRequestContext("http://mycompany.com/test?param=#[header:bar]");
        message.setPayload((Object)NullPayload.getInstance());
        try {
            transformer.transform((Object)message);
            ObjectToHttpClientMethodRequestTestCase.fail((String)"Header 'bar' not set on the message");
        }
        catch (MuleException e) {
            ObjectToHttpClientMethodRequestTestCase.assertTrue((e.getCause() instanceof RequiredValueException || e.getCause().getCause() instanceof RequiredValueException ? 1 : 0) != 0);
        }
    }

    public void testEncodingOfParamValueTriggeredByMessageProperty() throws Exception {
        String encodedPayload = "encoded%20payload";
        MuleMessage message = this.setupRequestContext("http://mycompany.com/", encodedPayload);
        message.setOutboundProperty("http.encode.paramvalue", (Object)false);
        ObjectToHttpClientMethodRequest transformer = this.createTransformer();
        Object result = transformer.transform((Object)message);
        ObjectToHttpClientMethodRequestTestCase.assertTrue((boolean)(result instanceof GetMethod));
        String expected = "body=" + encodedPayload;
        ObjectToHttpClientMethodRequestTestCase.assertEquals((String)expected, (String)((GetMethod)result).getQueryString());
    }
}

