/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.transformers;

import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.lang.SerializationUtils;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.api.transport.PropertyScope;
import org.mule.message.ds.StringDataSource;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpConstants;
import org.mule.transport.http.StreamPayloadRequestEntity;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.util.IOUtils;
import org.mule.util.ObjectUtils;

public class ObjectToHttpClientMethodRequest
extends AbstractMessageTransformer {
    private MuleContext muleContext;

    public ObjectToHttpClientMethodRequest() {
        this.setReturnDataType(DataTypeFactory.create(HttpMethod.class));
        this.registerSourceType(MuleMessage.class);
        this.registerSourceType(byte[].class);
        this.registerSourceType(String.class);
        this.registerSourceType(InputStream.class);
        this.registerSourceType(OutputHandler.class);
        this.registerSourceType(NullPayload.class);
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public Object transformMessage(MuleMessage msg, String outputEncoding) throws TransformerException {
        Object src = msg.getPayload();
        String endpoint = (String)msg.getOutboundProperty("MULE_ENDPOINT", null);
        if (endpoint == null) {
            throw new TransformerException(HttpMessages.eventPropertyNotSetCannotProcessRequest("MULE_ENDPOINT"), (Transformer)this);
        }
        String method = (String)msg.getProperty("http.method", PropertyScope.OUTBOUND);
        if (method == null && (method = (String)msg.getOutboundProperty("http.method", null)) == null) {
            method = (String)msg.getInvocationProperty("http.method", (Object)"POST");
        }
        try {
            GetMethod httpMethod;
            endpoint = endpoint.replaceAll("%23", "#");
            endpoint = this.muleContext.getExpressionManager().parse(endpoint, msg, true);
            URI uri = new URI(endpoint);
            if ("GET".equals(method)) {
                httpMethod = new GetMethod(uri.toString());
                String paramName = URLEncoder.encode((String)msg.getOutboundProperty("http.get.body.param", (Object)"body"), outputEncoding);
                Boolean encode = (Boolean)msg.getInvocationProperty("http.encode.paramvalue");
                if (encode == null) {
                    encode = (Boolean)msg.getOutboundProperty("http.encode.paramvalue", (Object)true);
                }
                String paramValue = encode != false ? URLEncoder.encode(src.toString(), outputEncoding) : src.toString();
                String query = uri.getRawQuery();
                if (!(src instanceof NullPayload) && !"".equals(src)) {
                    query = query == null ? paramName + "=" + paramValue : query + "&" + paramName + "=" + paramValue;
                }
                httpMethod.setQueryString(query);
            } else if ("POST".equalsIgnoreCase(method)) {
                PostMethod postMethod = new PostMethod(uri.toString());
                String paramName = (String)msg.getOutboundProperty("http.post.body.param", null);
                if (paramName == null) {
                    paramName = (String)msg.getInvocationProperty("http.post.body.param");
                }
                if (src instanceof Map) {
                    for (Map.Entry entry : ((Map)src).entrySet()) {
                        postMethod.addParameter(entry.getKey().toString(), entry.getValue().toString());
                    }
                } else if (paramName != null) {
                    postMethod.addParameter(paramName, src.toString());
                } else {
                    this.setupEntityMethod(src, outputEncoding, msg, (EntityEnclosingMethod)postMethod);
                }
                httpMethod = postMethod;
            } else if ("PUT".equalsIgnoreCase(method)) {
                PutMethod putMethod = new PutMethod(uri.toString());
                this.setupEntityMethod(src, outputEncoding, msg, (EntityEnclosingMethod)putMethod);
                httpMethod = putMethod;
            } else if ("DELETE".equalsIgnoreCase(method)) {
                httpMethod = new DeleteMethod(uri.toString());
            } else if ("HEAD".equalsIgnoreCase(method)) {
                httpMethod = new HeadMethod(uri.toString());
            } else if ("OPTIONS".equalsIgnoreCase(method)) {
                httpMethod = new OptionsMethod(uri.toString());
            } else if ("TRACE".equalsIgnoreCase(method)) {
                httpMethod = new TraceMethod(uri.toString());
            } else {
                throw new TransformerException(HttpMessages.unsupportedMethod(method));
            }
            HttpMethodParams params = (HttpMethodParams)msg.removeProperty("http.params", PropertyScope.OUTBOUND);
            if (params != null) {
                httpMethod.setParams(params);
            } else {
                String httpVersion = (String)msg.getOutboundProperty("http.version", (Object)"HTTP/1.1");
                if ("HTTP/1.0".equals(httpVersion)) {
                    httpMethod.getParams().setVersion(HttpVersion.HTTP_1_0);
                } else {
                    httpMethod.getParams().setVersion(HttpVersion.HTTP_1_1);
                }
            }
            this.setHeaders((HttpMethod)httpMethod, msg);
            return httpMethod;
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    protected void setupEntityMethod(Object src, String encoding, MuleMessage msg, EntityEnclosingMethod postMethod) throws UnsupportedEncodingException, TransformerException {
        if (!(msg.getPayload() instanceof NullPayload)) {
            String httpVersion;
            String mimeType = (String)msg.getProperty("Content-Type", PropertyScope.OUTBOUND);
            if (mimeType == null) {
                mimeType = "text/plain";
                this.logger.info((Object)("Content-Type not set on outgoing request, defaulting to: " + mimeType));
            }
            if (encoding != null && !"UTF-8".equals(encoding.toUpperCase()) && mimeType.indexOf("charset") == -1) {
                mimeType = mimeType + "; charset=" + encoding;
            }
            if ("HTTP/1.0".equals(httpVersion = (String)msg.getOutboundProperty("http.version", (Object)"HTTP/1.1"))) {
                try {
                    src = msg.getPayloadAsBytes();
                }
                catch (Exception e) {
                    throw new TransformerException((Transformer)this, (Throwable)e);
                }
            }
            if (msg.getOutboundAttachmentNames() != null && msg.getOutboundAttachmentNames().size() > 0) {
                try {
                    postMethod.setRequestEntity((RequestEntity)this.createMultiPart(msg, postMethod));
                    return;
                }
                catch (Exception e) {
                    throw new TransformerException((Transformer)this, (Throwable)e);
                }
            }
            if (src instanceof String) {
                postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(src.toString(), mimeType, encoding));
                return;
            }
            if (src instanceof InputStream) {
                postMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)src, mimeType));
            } else if (src instanceof byte[]) {
                postMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity((byte[])src, mimeType));
            } else if (src instanceof OutputHandler) {
                MuleEvent event = RequestContext.getEvent();
                postMethod.setRequestEntity((RequestEntity)new StreamPayloadRequestEntity((OutputHandler)src, event));
            } else {
                byte[] buffer = SerializationUtils.serialize((Serializable)((Serializable)src));
                postMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(buffer, mimeType));
            }
        } else if (msg.getOutboundAttachmentNames() != null && msg.getOutboundAttachmentNames().size() > 0) {
            try {
                postMethod.setRequestEntity((RequestEntity)this.createMultiPart(msg, postMethod));
            }
            catch (Exception e) {
                throw new TransformerException((Transformer)this, (Throwable)e);
            }
        }
    }

    protected void setHeaders(HttpMethod httpMethod, MuleMessage msg) throws TransformerException {
        for (String headerName : msg.getOutboundPropertyNames()) {
            String headerValue = ObjectUtils.getString((Object)msg.getOutboundProperty(headerName), null);
            if (headerName.startsWith("MULE_")) {
                headerName = new StringBuffer(30).append("X-").append(headerName).toString();
                httpMethod.addRequestHeader(headerName, headerValue);
                continue;
            }
            if (HttpConstants.RESPONSE_HEADER_NAMES.containsKey(headerName) || HttpConnector.HTTP_INBOUND_PROPERTIES.contains(headerName)) continue;
            httpMethod.addRequestHeader(headerName, headerValue);
        }
    }

    protected MultipartRequestEntity createMultiPart(MuleMessage msg, EntityEnclosingMethod method) throws Exception {
        Part[] parts;
        int i = 0;
        if (msg.getPayload() instanceof NullPayload) {
            parts = new Part[msg.getOutboundAttachmentNames().size()];
        } else {
            parts = new Part[msg.getOutboundAttachmentNames().size() + 1];
            parts[i++] = new FilePart("payload", (PartSource)new ByteArrayPartSource("payload", msg.getPayloadAsBytes()));
        }
        Iterator iterator = msg.getOutboundAttachmentNames().iterator();
        while (iterator.hasNext()) {
            String name;
            String fileName = name = (String)iterator.next();
            DataHandler dh = msg.getOutboundAttachment(name);
            if (dh.getDataSource() instanceof StringDataSource) {
                StringDataSource ds = (StringDataSource)dh.getDataSource();
                parts[i] = new StringPart(ds.getName(), IOUtils.toString((InputStream)ds.getInputStream()));
            } else {
                int x;
                if (dh.getDataSource() instanceof FileDataSource) {
                    fileName = ((FileDataSource)dh.getDataSource()).getFile().getName();
                } else if (dh.getDataSource() instanceof URLDataSource && (x = (fileName = ((URLDataSource)dh.getDataSource()).getURL().getFile()).lastIndexOf("/")) > -1) {
                    fileName = fileName.substring(x + 1);
                }
                parts[i] = new FilePart(dh.getName(), (PartSource)new ByteArrayPartSource(fileName, IOUtils.toByteArray((InputStream)dh.getInputStream())), dh.getContentType(), null);
            }
            ++i;
        }
        return new MultipartRequestEntity(parts, method.getParams());
    }
}

