/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mule.module.client.MuleClient;
import org.mule.transport.http.functional.AbstractMockHttpServerTestCase;
import org.mule.transport.http.functional.MockHttpServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpCookieTestCase
extends AbstractMockHttpServerTestCase {
    private static final int LISTEN_PORT = 60212;
    private static final String COOKIE_HEADER = "Cookie:";
    private CountDownLatch latch = new CountDownLatch(1);
    private boolean cookieFound = false;
    private List<String> cookieHeaders = new ArrayList<String>();

    protected String getConfigResources() {
        return "http-cookie-test.xml";
    }

    @Override
    protected MockHttpServer getHttpServer(CountDownLatch serverStartLatch) {
        return new SimpleHttpServer(60212, serverStartLatch, this.latch);
    }

    public void testCookies() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("COOKIE_HEADER", "MYCOOKIE");
        MuleClient client = new MuleClient(muleContext);
        client.dispatch("vm://vm-in", (Object)"foobar", properties);
        HttpCookieTestCase.assertTrue((boolean)this.latch.await(5000L, TimeUnit.MILLISECONDS));
        HttpCookieTestCase.assertTrue((boolean)this.cookieFound);
        HttpCookieTestCase.assertEquals((int)3, (int)this.cookieHeaders.size());
        this.assertThereIsCookieWithThisContent("Cookie: $Version=0; customCookie=yes", this.cookieHeaders);
        this.assertThereIsCookieWithThisContent("Cookie: $Version=0; expressionCookie=MYCOOKIE", this.cookieHeaders);
        this.assertThereIsCookieWithThisContent("MULE_SESSION=", this.cookieHeaders);
    }

    private void assertThereIsCookieWithThisContent(String content, List<String> listOfRawCookies) {
        for (String rawCookie : listOfRawCookies) {
            if (rawCookie == null || !rawCookie.contains(content)) continue;
            return;
        }
        HttpCookieTestCase.fail((String)("There should be a cookie with content '" + content + "': " + listOfRawCookies));
    }

    private class SimpleHttpServer
    extends MockHttpServer {
        public SimpleHttpServer(int listenPort, CountDownLatch startupLatch, CountDownLatch testCompleteLatch) {
            super(listenPort, startupLatch, testCompleteLatch);
        }

        protected void readHttpRequest(BufferedReader reader) throws Exception {
            String line = reader.readLine();
            while (line != null) {
                if (line.indexOf(HttpCookieTestCase.COOKIE_HEADER) > -1) {
                    HttpCookieTestCase.this.cookieFound = true;
                    HttpCookieTestCase.this.cookieHeaders.add(line);
                }
                if ((line = reader.readLine()).trim().length() != 0) continue;
                line = null;
            }
        }
    }
}

