/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mule.tck.FunctionalTestCase;

public class HttpMultipleCookiesTestCase
extends FunctionalTestCase {
    private static final int LOCAL_JETTY_SERVER_PORT = 4020;
    protected static String TEST_MESSAGE = "Test Http Request ";
    protected static final Log logger = LogFactory.getLog(HttpMultipleCookiesTestCase.class);
    private CountDownLatch simpleServerLatch = new CountDownLatch(1);
    private static AtomicBoolean cookiesRecieved = new AtomicBoolean(false);

    protected void suitePreSetUp() throws Exception {
        super.suitePreSetUp();
        this.startServer();
        HttpMultipleCookiesTestCase.assertTrue((boolean)this.simpleServerLatch.await(5000L, TimeUnit.MILLISECONDS));
    }

    protected String getConfigResources() {
        return "http-multiple-cookies-test.xml";
    }

    public void testSendDirectly() throws Exception {
        this.sendMessage(4020);
    }

    public void testSendviaMule() throws Exception {
        this.sendMessage(4019);
    }

    protected void sendMessage(int port) throws Exception {
        HttpClient client2 = new HttpClient();
        client2.getParams().setCookiePolicy("rfc2109");
        HttpState state = new HttpState();
        Cookie cookie1 = new Cookie("localhost", "TheFirst", "First", "/", null, false);
        state.addCookie(cookie1);
        Cookie cookie2 = new Cookie("localhost", "TheSecond", "Value2", "/", null, false);
        state.addCookie(cookie2);
        Cookie cookie3 = new Cookie("localhost", "TheThird", "Value3", "/", null, false);
        state.addCookie(cookie3);
        client2.setState(state);
        PostMethod method = new PostMethod("http://localhost:" + port);
        client2.executeMethod((HttpMethod)method);
        HttpMultipleCookiesTestCase.assertEquals((String)TEST_MESSAGE, (String)method.getResponseBodyAsString());
        HttpMultipleCookiesTestCase.assertTrue((String)"Cookies were not recieved", (boolean)cookiesRecieved.get());
        for (Cookie cookie : client2.getState().getCookies()) {
            logger.debug((Object)(cookie.getName() + " " + cookie.getValue()));
        }
        HttpMultipleCookiesTestCase.assertEquals((int)6, (int)client2.getState().getCookies().length);
    }

    protected void startServer() throws Exception {
        logger.debug((Object)"server starting");
        Server server = new Server();
        SocketConnector connector = new SocketConnector();
        connector.setPort(4020);
        server.setConnectors(new Connector[]{connector});
        ServletHandler handler = new ServletHandler();
        server.setHandler((Handler)handler);
        handler.addServletWithMapping(HelloServlet.class.getName(), "/");
        server.start();
        this.simpleServerLatch.countDown();
        logger.debug((Object)"Server started");
    }

    public static class HelloServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            try {
                response.setContentType("text/xml");
                response.setContentLength(TEST_MESSAGE.length());
                for (int i = 0; i < 3; ++i) {
                    javax.servlet.http.Cookie cookie1 = new javax.servlet.http.Cookie("OutputCookieName" + i, "OutputCookieValue" + i);
                    response.addCookie(cookie1);
                }
                cookiesRecieved.set(false);
                javax.servlet.http.Cookie[] cookies = request.getCookies();
                if (cookies != null) {
                    for (javax.servlet.http.Cookie cookie : cookies) {
                        logger.debug((Object)(cookie.getName() + " " + cookie.getValue()));
                        cookiesRecieved.set(true);
                    }
                }
                response.setStatus(200);
                response.getWriter().println(TEST_MESSAGE);
            }
            catch (Exception e) {
                logger.error((Object)"Servlet error", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        }

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            this.doGet(request, response);
        }
    }
}

