/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.BufferedReader;
import java.util.StringTokenizer;
import org.mule.module.client.MuleClient;
import org.mule.transport.http.functional.AbstractMockHttpServerTestCase;
import org.mule.transport.http.functional.MockHttpServer;
import org.mule.util.concurrent.Latch;

public class HttpOutboundTestCase
extends AbstractMockHttpServerTestCase {
    private static final int LISTEN_PORT = 60215;
    private Latch testLatch = new Latch();
    private String httpMethod;

    public HttpOutboundTestCase() {
        this.setDisposeManagerPerSuite(true);
    }

    protected MockHttpServer getHttpServer(CountDownLatch latch) {
        return new SimpleHttpServer(60215, latch, (CountDownLatch)this.testLatch);
    }

    protected String getConfigResources() {
        return "http-outbound-config.xml";
    }

    public void testOutboundDelete() throws Exception {
        this.sendHttpRequest("vm://doDelete", "DELETE");
    }

    public void testOutboundGet() throws Exception {
        this.sendHttpRequest("vm://doGet", "GET");
    }

    public void testOutboundHead() throws Exception {
        this.sendHttpRequest("vm://doHead", "HEAD");
    }

    public void testOutboundOptions() throws Exception {
        this.sendHttpRequest("vm://doOptions", "OPTIONS");
    }

    public void testOutboundPost() throws Exception {
        this.sendHttpRequest("vm://doPost", "POST");
    }

    public void testOutboundPut() throws Exception {
        this.sendHttpRequest("vm://doPut", "PUT");
    }

    public void testOutboundTrace() throws Exception {
        this.sendHttpRequest("vm://doTrace", "TRACE");
    }

    private void sendHttpRequest(String endpoint, String expectedHttpMethod) throws Exception {
        MuleClient client = new MuleClient(muleContext);
        client.dispatch(endpoint, (Object)"Test Message", null);
        HttpOutboundTestCase.assertTrue((boolean)this.testLatch.await(5000L, TimeUnit.MILLISECONDS));
        HttpOutboundTestCase.assertEquals((String)expectedHttpMethod, (String)this.httpMethod);
    }

    private class SimpleHttpServer
    extends MockHttpServer {
        public SimpleHttpServer(int listenPort, CountDownLatch startupLatch, CountDownLatch testCompleteLatch) {
            super(listenPort, startupLatch, testCompleteLatch);
        }

        protected void readHttpRequest(BufferedReader reader) throws Exception {
            String line = reader.readLine();
            HttpOutboundTestCase.this.httpMethod = new StringTokenizer(line).nextToken();
        }
    }
}

