/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.components;

import java.util.HashMap;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.DynamicPortTestCase;
import org.mule.transport.NullPayload;

public class RestServiceWrapperFunctionalTestCase
extends DynamicPortTestCase {
    protected static String TEST_REQUEST = "Test Http Request";

    protected String getConfigResources() {
        return "http-rest-service-wrapper-functional-test.xml";
    }

    public void testErrorExpressionOnRegexFilterFail() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("restServiceEndpoint", (Object)TEST_REQUEST, null);
        RestServiceWrapperFunctionalTestCase.assertTrue((boolean)(result.getPayload() instanceof NullPayload));
    }

    public void testErrorExpressionOnRegexFilterPass() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("restServiceEndpoint2", (Object)TEST_REQUEST, null);
        RestServiceWrapperFunctionalTestCase.assertEquals((String)("echo=" + TEST_REQUEST), (String)result.getPayloadAsString());
    }

    public void testRequiredParameters() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("baz-header", "baz");
        props.put("bar-optional-header", "bar");
        MuleMessage result = client.send("restServiceEndpoint3", null, props);
        RestServiceWrapperFunctionalTestCase.assertEquals((String)"foo=boo&faz=baz&far=bar", (String)result.getPayloadAsString());
    }

    public void testOptionalParametersMissing() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("baz-header", "baz");
        MuleMessage result = client.send("restServiceEndpoint3", null, props);
        RestServiceWrapperFunctionalTestCase.assertEquals((String)"foo=boo&faz=baz", (String)result.getPayloadAsString());
    }

    public void testRequiredParametersMissing() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        HashMap props = new HashMap();
        MuleMessage result = client.send("restServiceEndpoint3", null, props);
        RestServiceWrapperFunctionalTestCase.assertEquals((Object)NullPayload.getInstance(), (Object)result.getPayload());
        RestServiceWrapperFunctionalTestCase.assertNotNull((Object)result.getExceptionPayload());
    }

    protected int getNumPortsToFind() {
        return 1;
    }
}

