/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.HashMap;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.lang.time.StopWatch;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.DynamicPortTestCase;

public class HttpContinueFunctionalTestCase
extends DynamicPortTestCase {
    private static final int DEFAULT_HTTP_CLIENT_CONTINUE_WAIT = 3000;
    protected StopWatch stopWatch;

    protected String getConfigResources() {
        return "http-functional-test.xml";
    }

    public void testSendWithContinue() throws Exception {
        this.stopWatch = new StopWatch();
        MuleClient client = new MuleClient(muleContext);
        HttpClientParams params = new HttpClientParams();
        params.setVersion(HttpVersion.HTTP_1_1);
        params.setBooleanParameter("http.protocol.expect-continue", true);
        HashMap<String, HttpClientParams> props = new HashMap<String, HttpClientParams>();
        props.put("http.params", params);
        this.stopWatch.start();
        MuleMessage result = client.send("clientEndpoint", (Object)"Test Message", props);
        this.stopWatch.stop();
        HttpContinueFunctionalTestCase.assertNotNull((Object)result);
        HttpContinueFunctionalTestCase.assertEquals((String)"Test Message Received", (String)result.getPayloadAsString());
        if (this.stopWatch.getTime() > 3000L) {
            HttpContinueFunctionalTestCase.fail((String)"Server did not handle Expect=100-continue header properly,");
        }
    }

    protected int getNumPortsToFind() {
        return 1;
    }
}

