/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.HashMap;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.DynamicPortTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.util.concurrent.Latch;

public class HttpDynamicFunctionalTestCase
extends DynamicPortTestCase {
    protected static String TEST_MESSAGE = "Test Http Request";

    protected String getConfigResources() {
        return "http-dynamic-functional-test.xml";
    }

    public void testSend() throws Exception {
        final Latch latch1 = new Latch();
        final Latch latch2 = new Latch();
        FunctionalTestComponent tc1 = this.getFunctionalTestComponent("testComponent1");
        FunctionalTestComponent tc2 = this.getFunctionalTestComponent("testComponent2");
        HttpDynamicFunctionalTestCase.assertNotNull((Object)tc1);
        HttpDynamicFunctionalTestCase.assertNotNull((Object)tc2);
        tc1.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                latch1.release();
            }
        });
        tc2.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                latch2.release();
            }
        });
        MuleClient client = new MuleClient(muleContext);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("port", this.getPorts().get(0));
        props.put("path", "foo");
        MuleMessage result = client.send("clientEndpoint", (Object)TEST_MESSAGE, props);
        HttpDynamicFunctionalTestCase.assertEquals((String)(TEST_MESSAGE + " Received"), (String)result.getPayloadAsString());
        HttpDynamicFunctionalTestCase.assertTrue((boolean)latch1.await(3000L, TimeUnit.MILLISECONDS));
        props.put("port", this.getPorts().get(1));
        result = client.send("clientEndpoint", (Object)TEST_MESSAGE, props);
        HttpDynamicFunctionalTestCase.assertEquals((String)(TEST_MESSAGE + " Received"), (String)result.getPayloadAsString());
        HttpDynamicFunctionalTestCase.assertTrue((boolean)latch2.await(3000L, TimeUnit.MILLISECONDS));
    }

    protected int getNumPortsToFind() {
        return 2;
    }
}

