/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.module.client.MuleClient;
import org.mule.tck.DynamicPortTestCase;

public class HttpKeepAliveFunctionalTestCase
extends DynamicPortTestCase {
    private HttpClient http10Client;
    private HttpClient http11Client;
    private MuleClient client = null;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.http10Client = this.setupHttpClient(HttpVersion.HTTP_1_0);
        this.http11Client = this.setupHttpClient(HttpVersion.HTTP_1_1);
        this.client = new MuleClient(muleContext);
    }

    private HttpClient setupHttpClient(HttpVersion version) {
        HttpClientParams params = new HttpClientParams();
        params.setVersion(version);
        return new HttpClient(params);
    }

    protected String getConfigResources() {
        return "http-keep-alive-config.xml";
    }

    public void testHttp10WithoutConnectionHeader() throws Exception {
        GetMethod request = new GetMethod(((InboundEndpoint)this.client.getMuleContext().getRegistry().lookupObject("inWithoutEndpointOverride")).getAddress());
        request.removeRequestHeader("Connection");
        this.runHttp10MethodAndAssertConnectionHeader((HttpMethod)request, "close");
    }

    public void testHttp10WithCloseConnectionHeader() throws Exception {
        GetMethod request = new GetMethod(((InboundEndpoint)this.client.getMuleContext().getRegistry().lookupObject("inWithoutEndpointOverride")).getAddress());
        request.setRequestHeader("Connection", "close");
        this.runHttp10MethodAndAssertConnectionHeader((HttpMethod)request, "close");
    }

    public void testHttp10KeepAlive() throws Exception {
        this.doTestKeepAlive(((InboundEndpoint)this.client.getMuleContext().getRegistry().lookupObject("inWithoutEndpointOverride")).getAddress());
    }

    public void testHttp10KeepAliveWitEpOverride() throws Exception {
        this.doTestKeepAlive(((InboundEndpoint)this.client.getMuleContext().getRegistry().lookupObject("inWithoutEndpointOverride")).getAddress());
    }

    private void doTestKeepAlive(String url) throws Exception {
        GetMethod request = new GetMethod(url);
        request.addRequestHeader("Connection", "Keep-Alive");
        this.runHttp10MethodAndAssertConnectionHeader((HttpMethod)request, "Keep-Alive");
        request.setRequestHeader("Connection", "close");
        this.runHttp10MethodAndAssertConnectionHeader((HttpMethod)request, "close");
    }

    private void runHttp10MethodAndAssertConnectionHeader(HttpMethod request, String expectedConnectionHeaderValue) throws Exception {
        int status = this.http10Client.executeMethod(request);
        HttpKeepAliveFunctionalTestCase.assertEquals((int)200, (int)status);
        String connectionHeader = request.getResponseHeader("Connection").getValue();
        HttpKeepAliveFunctionalTestCase.assertNotNull((Object)connectionHeader);
        HttpKeepAliveFunctionalTestCase.assertEquals((String)expectedConnectionHeaderValue, (String)connectionHeader);
    }

    public void testHttp11KeepAlive() throws Exception {
        this.doTestHttp11KeepAlive(((InboundEndpoint)this.client.getMuleContext().getRegistry().lookupObject("inWithoutEndpointOverride")).getAddress());
    }

    public void testHttp11KeepAliveWithEpOverride() throws Exception {
        this.doTestHttp11KeepAlive(((InboundEndpoint)this.client.getMuleContext().getRegistry().lookupObject("inWithoutEndpointOverride")).getAddress());
    }

    public void doTestHttp11KeepAlive(String url) throws Exception {
        GetMethod request = new GetMethod(url);
        this.runHttp11MethodAndAssert((HttpMethod)request);
        request = new GetMethod(url);
        request.setRequestHeader("Connection", "close");
        this.runHttp11MethodAndAssert((HttpMethod)request);
        Header connectHeader = request.getResponseHeader("Connection");
        HttpKeepAliveFunctionalTestCase.assertNotNull((Object)connectHeader);
        HttpKeepAliveFunctionalTestCase.assertEquals((String)"close", (String)connectHeader.getValue());
    }

    private void runHttp11MethodAndAssert(HttpMethod request) throws Exception {
        int status = this.http11Client.executeMethod(request);
        HttpKeepAliveFunctionalTestCase.assertEquals((int)200, (int)status);
        HttpKeepAliveFunctionalTestCase.assertEquals((String)"/http-in", (String)request.getResponseBodyAsString());
    }

    protected int getNumPortsToFind() {
        return 2;
    }
}

