/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.net.SocketTimeoutException;
import java.util.Date;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transport.DispatchException;
import org.mule.module.client.MuleClient;
import org.mule.tck.DynamicPortTestCase;

public class HttpResponseTimeoutTestCase
extends DynamicPortTestCase {
    protected static String PAYLOAD = "Eugene";
    protected static int DEFAULT_RESPONSE_TIMEOUT = 2000;
    protected MuleClient muleClient;

    protected String getConfigResources() {
        return "http-response-timeout-config.xml";
    }

    protected String getPayload() {
        return PAYLOAD;
    }

    protected String getProcessedPayload() {
        return this.getPayload() + " processed";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.muleClient = new MuleClient(muleContext);
    }

    public void testDecreaseOutboundEndpointResponseTimeout() throws Exception {
        Date beforeCall = new Date();
        MuleMessage message = this.muleClient.send("vm://decreaseTimeoutRequest", (Object)this.getPayload(), null);
        Date afterCall = new Date();
        HttpResponseTimeoutTestCase.assertNotNull((Object)message);
        HttpResponseTimeoutTestCase.assertNotNull((String)this.getPayload(), (Object)message.getPayloadAsString());
        HttpResponseTimeoutTestCase.assertTrue((boolean)(message.getExceptionPayload().getRootException() instanceof SocketTimeoutException));
        HttpResponseTimeoutTestCase.assertTrue((afterCall.getTime() - beforeCall.getTime() < (long)DEFAULT_RESPONSE_TIMEOUT ? 1 : 0) != 0);
    }

    public void testIncreaseOutboundEndpointResponseTimeout() throws Exception {
        Date beforeCall = new Date();
        MuleMessage message = this.muleClient.send("vm://increaseTimeoutRequest", (Object)this.getPayload(), null);
        Date afterCall = new Date();
        HttpResponseTimeoutTestCase.assertNotNull((Object)message);
        HttpResponseTimeoutTestCase.assertNull((Object)message.getExceptionPayload());
        HttpResponseTimeoutTestCase.assertNotNull((String)this.getPayload(), (Object)message.getPayloadAsString());
        HttpResponseTimeoutTestCase.assertTrue((afterCall.getTime() - beforeCall.getTime() > (long)DEFAULT_RESPONSE_TIMEOUT ? 1 : 0) != 0);
    }

    public void testDecreaseMuleClientSendResponseTimeout() throws Exception {
        Date beforeCall = new Date();
        try {
            this.muleClient.send(((InboundEndpoint)this.muleClient.getMuleContext().getRegistry().lookupObject("inDelayService")).getAddress(), (Object)this.getPayload(), null, 1000);
            HttpResponseTimeoutTestCase.fail((String)"SocketTimeoutException expected");
        }
        catch (DispatchException e) {
            HttpResponseTimeoutTestCase.assertTrue((boolean)(e.getCause() instanceof SocketTimeoutException));
        }
        Date afterCall = new Date();
        HttpResponseTimeoutTestCase.assertTrue((afterCall.getTime() - beforeCall.getTime() < (long)DEFAULT_RESPONSE_TIMEOUT ? 1 : 0) != 0);
    }

    public void testIncreaseMuleClientSendResponseTimeout() throws Exception {
        Date beforeCall = new Date();
        MuleMessage message = this.muleClient.send(((InboundEndpoint)this.muleClient.getMuleContext().getRegistry().lookupObject("inDelayService")).getAddress(), (Object)this.getPayload(), null, 3000);
        Date afterCall = new Date();
        HttpResponseTimeoutTestCase.assertNotNull((Object)message);
        HttpResponseTimeoutTestCase.assertNull((Object)message.getExceptionPayload());
        HttpResponseTimeoutTestCase.assertNotNull((String)this.getProcessedPayload(), (Object)message.getPayloadAsString());
        HttpResponseTimeoutTestCase.assertTrue((afterCall.getTime() - beforeCall.getTime() > (long)DEFAULT_RESPONSE_TIMEOUT ? 1 : 0) != 0);
    }

    protected int getNumPortsToFind() {
        return 1;
    }
}

