/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.transformers;

import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.GetMethod;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transport.NullPayload;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.RequestLine;
import org.mule.transport.http.transformers.ObjectToHttpClientMethodRequest;

public class ObjectToHttpClientMethodRequestTestCase
extends AbstractMuleTestCase {
    private MuleMessage setupRequestContext(String url) throws Exception {
        HttpRequest request = new HttpRequest(new RequestLine("GET", url, HttpVersion.HTTP_1_1), null, "UTF-8");
        MuleEvent event = ObjectToHttpClientMethodRequestTestCase.getTestEvent((Object)request, (ImmutableEndpoint)muleContext.getEndpointFactory().getInboundEndpoint(url));
        MuleMessage message = event.getMessage();
        message.setOutboundProperty("http.method", (Object)"GET");
        message.setOutboundProperty("MULE_ENDPOINT", (Object)url);
        RequestContext.setEvent((MuleEvent)event);
        return message;
    }

    private ObjectToHttpClientMethodRequest createTransformer() throws Exception {
        ObjectToHttpClientMethodRequest transformer = new ObjectToHttpClientMethodRequest();
        transformer.setMuleContext(muleContext);
        transformer.setEndpoint(RequestContext.getEvent().getEndpoint());
        transformer.initialise();
        return transformer;
    }

    protected void doTearDown() throws Exception {
        RequestContext.setEvent(null);
    }

    public void testUrlWithoutQuery() throws Exception {
        MuleMessage message = this.setupRequestContext("http://localhost:8080/services");
        message.setPayload((Object)NullPayload.getInstance());
        ObjectToHttpClientMethodRequest transformer = this.createTransformer();
        Object response = transformer.transform((Object)message);
        ObjectToHttpClientMethodRequestTestCase.assertTrue((boolean)(response instanceof HttpMethod));
        HttpMethod httpMethod = (HttpMethod)response;
        ObjectToHttpClientMethodRequestTestCase.assertEquals(null, (String)httpMethod.getQueryString());
    }

    public void testUrlWithQuery() throws Exception {
        MuleMessage message = this.setupRequestContext("http://localhost:8080/services?method=echo");
        message.setPayload((Object)NullPayload.getInstance());
        ObjectToHttpClientMethodRequest transformer = this.createTransformer();
        Object response = transformer.transform((Object)message);
        ObjectToHttpClientMethodRequestTestCase.assertTrue((boolean)(response instanceof HttpMethod));
        HttpMethod httpMethod = (HttpMethod)response;
        ObjectToHttpClientMethodRequestTestCase.assertEquals((String)"method=echo", (String)httpMethod.getQueryString());
    }

    public void testUrlWithUnescapedQuery() throws Exception {
        MuleMessage message = this.setupRequestContext("http://mycompany.com/test?fruits=apple%20orange");
        message.setPayload((Object)NullPayload.getInstance());
        ObjectToHttpClientMethodRequest transformer = this.createTransformer();
        Object response = transformer.transform((Object)message);
        ObjectToHttpClientMethodRequestTestCase.assertTrue((boolean)(response instanceof HttpMethod));
        HttpMethod httpMethod = (HttpMethod)response;
        ObjectToHttpClientMethodRequestTestCase.assertEquals((String)"fruits=apple%20orange", (String)httpMethod.getQueryString());
    }

    public void testAppendedUrl() throws Exception {
        MuleMessage message = this.setupRequestContext("http://mycompany.com/test?fruits=apple%20orange");
        message.setPayload((Object)"test");
        message.setOutboundProperty("http.get.body.param", (Object)"body");
        ObjectToHttpClientMethodRequest transformer = this.createTransformer();
        Object response = transformer.transform((Object)message);
        ObjectToHttpClientMethodRequestTestCase.assertTrue((boolean)(response instanceof HttpMethod));
        HttpMethod httpMethod = (HttpMethod)response;
        ObjectToHttpClientMethodRequestTestCase.assertEquals((String)"fruits=apple%20orange&body=test", (String)httpMethod.getQueryString());
    }

    public void testEncodingOfParamValueTriggeredByMessageProperty() throws Exception {
        String encodedPayload = "encoded%20payload";
        MuleMessage message = this.setupRequestContext("http://mycompany.com/");
        message.setOutboundProperty("http.encode.paramvalue", (Object)false);
        message.setOutboundProperty("http.get.body.param", (Object)"body");
        message.setPayload((Object)encodedPayload);
        ObjectToHttpClientMethodRequest transformer = this.createTransformer();
        Object result = transformer.transform((Object)message);
        ObjectToHttpClientMethodRequestTestCase.assertTrue((boolean)(result instanceof GetMethod));
        String expected = "body=" + encodedPayload;
        ObjectToHttpClientMethodRequestTestCase.assertEquals((String)expected, (String)((GetMethod)result).getQueryString());
    }
}

