/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transport.http.CookieHelper;
import org.mule.transport.http.CookieStorageType;

public class CookieHelperTestCase
extends AbstractMuleTestCase {
    private static final String COOKIE_1_NAME = "cookie1";
    private static final String COOKIE_1_ORIGINAL_VALUE = "value1";
    private static final String COOKIE_2_NAME = "cookie2";
    private static final String COOKIE_2_VALUE = "value2";
    private static final String COOKIE_1_NEW_VALUE = "newValue1 That Overrides Previous One";

    public void testPutAndMergeCookieObjectMapOfStringString_CookiesInMap_NewCookiesInMap() {
        Map cookiesObject = new HashMap<String, String>();
        cookiesObject.put(COOKIE_1_NAME, COOKIE_1_ORIGINAL_VALUE);
        CookieHelperTestCase.assertEquals((int)1, (int)cookiesObject.size());
        HashMap<String, String> newCookiesMap = new HashMap<String, String>();
        newCookiesMap.put(COOKIE_1_NAME, COOKIE_1_NEW_VALUE);
        newCookiesMap.put(COOKIE_2_NAME, COOKIE_2_VALUE);
        cookiesObject = (Map)CookieHelper.putAndMergeCookie(cookiesObject, newCookiesMap);
        CookieHelperTestCase.assertEquals((int)2, (int)cookiesObject.size());
        CookieHelperTestCase.assertEquals((String)COOKIE_1_NEW_VALUE, (String)((String)cookiesObject.get(COOKIE_1_NAME)));
        CookieHelperTestCase.assertEquals((String)COOKIE_2_VALUE, (String)((String)cookiesObject.get(COOKIE_2_NAME)));
        Map unModifiedCookiesObject = (Map)CookieHelper.putAndMergeCookie(cookiesObject, (Map)null);
        CookieHelperTestCase.assertSame(cookiesObject, (Object)unModifiedCookiesObject);
        CookieHelperTestCase.assertEquals((int)2, (int)cookiesObject.size());
    }

    public void testPutAndMergeCookieObjectMapOfStringString_CookiesInArray_NewCookiesInMap() {
        Cookie[] cookiesObject = new Cookie[]{new Cookie(null, COOKIE_1_NAME, COOKIE_1_ORIGINAL_VALUE)};
        HashMap<String, String> newCookiesMap = new HashMap<String, String>();
        newCookiesMap.put(COOKIE_1_NAME, COOKIE_1_NEW_VALUE);
        newCookiesMap.put(COOKIE_2_NAME, COOKIE_2_VALUE);
        cookiesObject = (Cookie[])CookieHelper.putAndMergeCookie((Object)cookiesObject, newCookiesMap);
        CookieHelperTestCase.assertEquals((int)2, (int)cookiesObject.length);
        CookieHelperTestCase.assertEquals((String)COOKIE_1_NAME, (String)cookiesObject[0].getName());
        CookieHelperTestCase.assertEquals((String)COOKIE_1_NEW_VALUE, (String)cookiesObject[0].getValue());
        CookieHelperTestCase.assertEquals((String)COOKIE_2_NAME, (String)cookiesObject[1].getName());
        CookieHelperTestCase.assertEquals((String)COOKIE_2_VALUE, (String)cookiesObject[1].getValue());
        Cookie[] unModifiedCookiesObject = (Cookie[])CookieHelper.putAndMergeCookie((Object)cookiesObject, (Map)null);
        CookieHelperTestCase.assertSame((Object)cookiesObject, (Object)unModifiedCookiesObject);
        CookieHelperTestCase.assertEquals((int)2, (int)cookiesObject.length);
    }

    public void testPutAndMergeCookieObjectCookieArray_CookiesInMap_NewCookiesInArray() {
        Map cookiesObject = new HashMap<String, String>();
        cookiesObject.put(COOKIE_1_NAME, COOKIE_1_ORIGINAL_VALUE);
        CookieHelperTestCase.assertEquals((int)1, (int)cookiesObject.size());
        Cookie[] newCookiesArray = new Cookie[]{new Cookie(null, COOKIE_1_NAME, COOKIE_1_NEW_VALUE), new Cookie(null, COOKIE_2_NAME, COOKIE_2_VALUE)};
        cookiesObject = (Map)CookieHelper.putAndMergeCookie(cookiesObject, (Cookie[])newCookiesArray);
        CookieHelperTestCase.assertEquals((int)2, (int)cookiesObject.size());
        CookieHelperTestCase.assertEquals((String)COOKIE_1_NEW_VALUE, (String)((String)cookiesObject.get(COOKIE_1_NAME)));
        CookieHelperTestCase.assertEquals((String)COOKIE_2_VALUE, (String)((String)cookiesObject.get(COOKIE_2_NAME)));
        Map unModifiedCookiesObject = (Map)CookieHelper.putAndMergeCookie(cookiesObject, (Cookie[])null);
        CookieHelperTestCase.assertSame(cookiesObject, (Object)unModifiedCookiesObject);
        CookieHelperTestCase.assertEquals((int)2, (int)cookiesObject.size());
    }

    public void testPutAndMergeCookieObjectCookieArray_CookiesInArray_NewCookiesInArray() {
        Cookie[] cookiesObject = new Cookie[]{new Cookie(null, COOKIE_1_NAME, COOKIE_1_ORIGINAL_VALUE)};
        CookieHelperTestCase.assertEquals((int)1, (int)cookiesObject.length);
        Cookie[] newCookiesArray = new Cookie[]{new Cookie(null, COOKIE_1_NAME, COOKIE_1_NEW_VALUE), new Cookie(null, COOKIE_2_NAME, COOKIE_2_VALUE)};
        cookiesObject = (Cookie[])CookieHelper.putAndMergeCookie((Object)cookiesObject, (Cookie[])newCookiesArray);
        CookieHelperTestCase.assertEquals((int)2, (int)cookiesObject.length);
        CookieHelperTestCase.assertEquals((String)COOKIE_1_NAME, (String)cookiesObject[0].getName());
        CookieHelperTestCase.assertEquals((String)COOKIE_1_NEW_VALUE, (String)cookiesObject[0].getValue());
        CookieHelperTestCase.assertEquals((String)COOKIE_2_NAME, (String)cookiesObject[1].getName());
        CookieHelperTestCase.assertEquals((String)COOKIE_2_VALUE, (String)cookiesObject[1].getValue());
        Cookie[] unModifiedCookiesObject = (Cookie[])CookieHelper.putAndMergeCookie((Object)cookiesObject, (Cookie[])null);
        CookieHelperTestCase.assertSame((Object)cookiesObject, (Object)unModifiedCookiesObject);
        CookieHelperTestCase.assertEquals((int)2, (int)cookiesObject.length);
    }

    public void testAsArrayOfCookies_CookiesInArray() throws Exception {
        Cookie[] cookiesObject = new Cookie[]{new Cookie()};
        CookieHelperTestCase.assertSame((Object)cookiesObject, (Object)CookieHelper.asArrayOfCookies((Object)cookiesObject));
        Cookie[] emptyArray = CookieHelper.asArrayOfCookies(null);
        CookieHelperTestCase.assertNotNull((String)"A null cookiesObject should return a non null array", (Object)emptyArray);
        CookieHelperTestCase.assertEquals((int)0, (int)emptyArray.length);
    }

    public void testAsArrayOfCookies_CookiesInMap() throws Exception {
        LinkedHashMap<String, String> cookiesObject = new LinkedHashMap<String, String>();
        cookiesObject.put(COOKIE_1_NAME, COOKIE_1_ORIGINAL_VALUE);
        cookiesObject.put(COOKIE_2_NAME, COOKIE_2_VALUE);
        Cookie[] cookiesAsArray = CookieHelper.asArrayOfCookies(cookiesObject);
        CookieHelperTestCase.assertNotNull((String)"Array of cookies should not be null", (Object)cookiesAsArray);
        CookieHelperTestCase.assertEquals((int)2, (int)cookiesAsArray.length);
        CookieHelperTestCase.assertEquals((String)COOKIE_1_NAME, (String)cookiesAsArray[0].getName());
        CookieHelperTestCase.assertEquals((String)COOKIE_1_ORIGINAL_VALUE, (String)cookiesAsArray[0].getValue());
        CookieHelperTestCase.assertEquals((String)COOKIE_2_NAME, (String)cookiesAsArray[1].getName());
        CookieHelperTestCase.assertEquals((String)COOKIE_2_VALUE, (String)cookiesAsArray[1].getValue());
    }

    public void testResolveCookieStorageType() throws Exception {
        CookieHelperTestCase.assertSame((Object)CookieStorageType.MAP_STRING_STRING, (Object)CookieStorageType.resolveCookieStorageType(new HashMap()));
        CookieHelperTestCase.assertSame((Object)CookieStorageType.ARRAY_OF_COOKIES, (Object)CookieStorageType.resolveCookieStorageType(null));
        CookieHelperTestCase.assertSame((Object)CookieStorageType.ARRAY_OF_COOKIES, (Object)CookieStorageType.resolveCookieStorageType((Object)new Cookie[2]));
        try {
            CookieStorageType.resolveCookieStorageType((Object)new Object());
            CookieHelperTestCase.fail((String)"It should have thrown an exception since Object it is not a valid type");
        }
        catch (IllegalArgumentException e) {
            CookieHelperTestCase.assertTrue((boolean)e.getMessage().contains("Invalid cookiesObject"));
        }
    }
}

