/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.filters;

import java.util.HashMap;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.module.client.MuleClient;
import org.mule.tck.DynamicPortTestCase;

public class HttpRequestWildcardFilterTestCase
extends DynamicPortTestCase {
    private static final String TEST_HTTP_MESSAGE = "Hello=World";
    private static final String TEST_BAD_MESSAGE = "xyz";

    protected String getConfigResources() {
        return "http-wildcard-filter-test.xml";
    }

    public void testReference() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send(((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject("inReference")).getAddress(), (Object)TEST_HTTP_MESSAGE, null);
        HttpRequestWildcardFilterTestCase.assertEquals((String)TEST_HTTP_MESSAGE, (String)result.getPayloadAsString());
    }

    public void testHttpPost() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send(((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject("inHttpIn")).getAddress(), (Object)TEST_HTTP_MESSAGE, null);
        HttpRequestWildcardFilterTestCase.assertEquals((String)TEST_HTTP_MESSAGE, (String)result.getPayloadAsString());
    }

    public void testHttpGetNotFiltered() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("GET", "true");
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send(((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject("inHttpIn")).getAddress() + "/" + "mulerulez", (Object)TEST_HTTP_MESSAGE, props);
        HttpRequestWildcardFilterTestCase.assertEquals((String)TEST_HTTP_MESSAGE, (String)result.getPayloadAsString());
    }

    public void testHttpGetFiltered() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("http.method", "GET");
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send(((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject("inHttpIn")).getAddress() + "/" + TEST_BAD_MESSAGE, (Object)"mule", props);
        int status = (Integer)result.getInboundProperty("http.status", (Object)0);
        HttpRequestWildcardFilterTestCase.assertEquals((int)406, (int)status);
        HttpRequestWildcardFilterTestCase.assertNotNull((Object)result.getExceptionPayload());
    }

    protected int getNumPortsToFind() {
        return 2;
    }
}

