/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import junit.framework.Assert;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.DynamicPortTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.util.IOUtils;
import org.mule.util.StringDataSource;

public class HttpAttachmentsFunctionalTestCase
extends DynamicPortTestCase {
    protected String getConfigResources() {
        return "http-attachments-functional-test.xml";
    }

    public void testSendAttachment() throws Exception {
        FunctionalTestComponent ftc = this.getFunctionalTestComponent("testComponent");
        HttpAttachmentsFunctionalTestCase.assertNotNull((Object)ftc);
        ftc.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                Assert.assertEquals((Object)"application/octet-stream; charset=ISO-8859-1", (Object)context.getMessage().getInboundProperty("Content-Type"));
                Assert.assertEquals((String)"We should have an attachment", (int)1, (int)context.getMessage().getInboundAttachmentNames().size());
                DataHandler dh = context.getMessage().getInboundAttachment("attach1");
                Assert.assertNotNull((String)"DataHandler with name 'attach1' should not be null", (Object)dh);
                Assert.assertEquals((String)"We should have an attachment with foo", (String)"foo", (String)IOUtils.toString((InputStream)dh.getInputStream()));
                Assert.assertEquals((String)"text/plain; charset=ISO-8859-1", (String)dh.getContentType());
            }
        });
        LocalMuleClient client = muleContext.getClient();
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"test", muleContext);
        msg.addOutboundAttachment("attach1", new DataHandler((DataSource)new StringDataSource("foo", "attach1")));
        MuleMessage result = client.send("endpoint1", (MuleMessage)msg);
        HttpAttachmentsFunctionalTestCase.assertEquals((String)"We should have no attachments coming back", (int)0, (int)result.getInboundAttachmentNames().size());
    }

    protected int getNumPortsToFind() {
        return 1;
    }
}

