/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.HashMap;
import junit.framework.Assert;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.DynamicPortTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;

public class HttpFunctionalTestCase
extends DynamicPortTestCase {
    protected static String TEST_MESSAGE = "Test Http Request (R\u00ef\u00bf\u00bddgr\u00ef\u00bf\u00bdd), 57 = \u06f7\u06f5 in Arabic";
    protected boolean checkPathProperties = true;

    protected String getConfigResources() {
        return "http-functional-test.xml";
    }

    public void testSend() throws Exception {
        FunctionalTestComponent testComponent = this.getFunctionalTestComponent("testComponent");
        HttpFunctionalTestCase.assertNotNull((Object)testComponent);
        if (this.checkPathProperties) {
            EventCallback callback = new EventCallback(){

                public void eventReceived(MuleEventContext context, Object component) throws Exception {
                    MuleMessage msg = context.getMessage();
                    Assert.assertEquals((Object)"/", (Object)msg.getInboundProperty("http.request"));
                    Assert.assertEquals((Object)"/", (Object)msg.getInboundProperty("http.request.path"));
                    Assert.assertEquals((Object)"/", (Object)msg.getInboundProperty("http.context.path"));
                }
            };
            testComponent.setEventCallback(callback);
        }
        MuleClient client = new MuleClient(muleContext);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("Content-Type", "text/plain;charset=UTF-8");
        MuleMessage result = client.send("clientEndpoint", (Object)TEST_MESSAGE, props);
        HttpFunctionalTestCase.assertEquals((String)(TEST_MESSAGE + " Received"), (String)result.getPayloadAsString());
    }

    protected int getNumPortsToFind() {
        return 1;
    }
}

