/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.module.client.MuleClient;
import org.mule.tck.DynamicPortTestCase;

public class HttpMethodTestCase
extends DynamicPortTestCase {
    private HttpMethodBase method;
    private MuleClient muleClient = null;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.muleClient = new MuleClient(muleContext);
    }

    protected String getConfigResources() {
        return "http-method-test.xml";
    }

    protected void doFunctionalTearDown() throws Exception {
        if (this.method != null) {
            this.method.releaseConnection();
        }
    }

    public void testHead() throws Exception {
        HttpClient client = new HttpClient();
        this.method = new HeadMethod(((InboundEndpoint)this.muleClient.getMuleContext().getRegistry().lookupObject("inHttpIn")).getAddress());
        int statusCode = client.executeMethod((HttpMethod)this.method);
        HttpMethodTestCase.assertEquals((String)Integer.toString(200), (String)Integer.toString(statusCode));
    }

    public void testOptions() throws Exception {
        HttpClient client = new HttpClient();
        this.method = new OptionsMethod(((InboundEndpoint)this.muleClient.getMuleContext().getRegistry().lookupObject("inHttpIn")).getAddress());
        int statusCode = client.executeMethod((HttpMethod)this.method);
        HttpMethodTestCase.assertEquals((String)Integer.toString(200), (String)Integer.toString(statusCode));
    }

    public void testPut() throws Exception {
        HttpClient client = new HttpClient();
        this.method = new PutMethod(((InboundEndpoint)this.muleClient.getMuleContext().getRegistry().lookupObject("inHttpIn")).getAddress());
        int statusCode = client.executeMethod((HttpMethod)this.method);
        HttpMethodTestCase.assertEquals((String)Integer.toString(200), (String)Integer.toString(statusCode));
    }

    public void testDelete() throws Exception {
        HttpClient client = new HttpClient();
        this.method = new DeleteMethod(((InboundEndpoint)this.muleClient.getMuleContext().getRegistry().lookupObject("inHttpIn")).getAddress());
        int statusCode = client.executeMethod((HttpMethod)this.method);
        HttpMethodTestCase.assertEquals((String)Integer.toString(200), (String)Integer.toString(statusCode));
    }

    public void testTrace() throws Exception {
        HttpClient client = new HttpClient();
        this.method = new TraceMethod(((InboundEndpoint)this.muleClient.getMuleContext().getRegistry().lookupObject("inHttpIn")).getAddress());
        int statusCode = client.executeMethod((HttpMethod)this.method);
        HttpMethodTestCase.assertEquals((String)Integer.toString(200), (String)Integer.toString(statusCode));
    }

    public void testConnect() throws Exception {
        HttpClient client = new HttpClient();
        this.method = new HttpMethodBase(((InboundEndpoint)this.muleClient.getMuleContext().getRegistry().lookupObject("inHttpIn")).getAddress()){

            public String getName() {
                return "CONNECT";
            }
        };
        int statusCode = client.executeMethod((HttpMethod)this.method);
        HttpMethodTestCase.assertEquals((String)Integer.toString(200), (String)Integer.toString(statusCode));
    }

    public void testFoo() throws Exception {
        HttpClient client = new HttpClient();
        this.method = new HttpMethodBase(((InboundEndpoint)this.muleClient.getMuleContext().getRegistry().lookupObject("inHttpIn")).getAddress()){

            public String getName() {
                return "FOO";
            }
        };
        int statusCode = client.executeMethod((HttpMethod)this.method);
        HttpMethodTestCase.assertEquals((String)Integer.toString(400), (String)Integer.toString(statusCode));
    }

    protected int getNumPortsToFind() {
        return 1;
    }
}

