/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import junit.framework.Assert;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.DynamicPortTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;

public class HttpStemTestCase
extends DynamicPortTestCase {
    protected String getConfigResources() {
        return "http-stem-test.xml";
    }

    public void testStemMatching() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        int port = (Integer)this.getPorts().get(0);
        this.doTest(client, "http://localhost:" + port + "/foo", "/foo", "/foo");
        this.doTest(client, "http://localhost:" + port + "/foo/baz", "/foo", "/foo/baz");
        this.doTest(client, "http://localhost:" + port + "/bar", "/bar", "/bar");
        this.doTest(client, "http://localhost:" + port + "/bar/baz", "/bar", "/bar/baz");
    }

    protected void doTest(MuleClient client, String url, final String contextPath, final String requestPath) throws Exception {
        FunctionalTestComponent testComponent = (FunctionalTestComponent)this.getComponent(contextPath);
        HttpStemTestCase.assertNotNull((Object)testComponent);
        EventCallback callback = new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                MuleMessage msg = context.getMessage();
                Assert.assertEquals((Object)requestPath, (Object)msg.getInboundProperty("http.request"));
                Assert.assertEquals((Object)requestPath, (Object)msg.getInboundProperty("http.request.path"));
                Assert.assertEquals((Object)contextPath, (Object)msg.getInboundProperty("http.context.path"));
            }
        };
        testComponent.setEventCallback(callback);
        MuleMessage result = client.send(url, (Object)"Hello World", null);
        HttpStemTestCase.assertEquals((String)"Hello World Received", (String)result.getPayloadAsString());
        int status = (Integer)result.getInboundProperty("http.status", (Object)0);
        HttpStemTestCase.assertEquals((int)200, (int)status);
    }

    protected int getNumPortsToFind() {
        return 1;
    }
}

