/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.ArrayList;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transformer.DataType;
import org.mule.module.client.MuleClient;
import org.mule.tck.DynamicPortTestCase;

public class TwoEndpointsSinglePortTestCase
extends DynamicPortTestCase {
    protected String getConfigResources() {
        return "two-endpoints-single-port.xml";
    }

    public void testSendToEach() throws Exception {
        this.sendWithResponse("inMyComponent1", "test", "mycomponent1", 10);
        this.sendWithResponse("inMyComponent2", "test", "mycomponent2", 10);
    }

    public void testSendToEachWithBadEndpoint() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        this.sendWithResponse("inMyComponent1", "test", "mycomponent1", 5);
        this.sendWithResponse("inMyComponent2", "test", "mycomponent2", 5);
        MuleMessage result = client.send("http://localhost:" + this.getPorts().get(0) + "/mycomponent-notfound", (Object)"test", null);
        TwoEndpointsSinglePortTestCase.assertNotNull((Object)result);
        TwoEndpointsSinglePortTestCase.assertNotNull((Object)result.getExceptionPayload());
        int status = (Integer)result.getInboundProperty("http.status", (Object)0);
        TwoEndpointsSinglePortTestCase.assertEquals((int)404, (int)status);
        this.sendWithResponse("inMyComponent1", "test", "mycomponent1", 5);
        this.sendWithResponse("inMyComponent2", "test", "mycomponent2", 5);
    }

    protected void sendWithResponse(String endPointName, String message, String response, int noOfMessages) throws MuleException {
        int i;
        MuleClient client = new MuleClient(muleContext);
        ArrayList<Object> results = new ArrayList<Object>();
        for (i = 0; i < noOfMessages; ++i) {
            results.add(client.send(((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject(endPointName)).getAddress(), (Object)message, null).getPayload(DataType.BYTE_ARRAY_DATA_TYPE));
        }
        TwoEndpointsSinglePortTestCase.assertEquals((int)noOfMessages, (int)results.size());
        for (i = 0; i < noOfMessages; ++i) {
            TwoEndpointsSinglePortTestCase.assertEquals((String)response, (String)new String((byte[])results.get(i)));
        }
    }

    protected int getNumPortsToFind() {
        return 1;
    }
}

