/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.transformers;

import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpVersion;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.http.HttpResponse;
import org.mule.transport.http.transformers.HttpResponseToString;

public class HttpResponseToStringTestCase
extends AbstractMuleTestCase {
    private final String _statusLine = "HTTP/1.1 200 OK";
    private final String _headerCT = "Content-Type: text/plain";
    private final String _headerTE = "Transfer-Encoding: chunked";
    private final String _contentLength = "Content-Length: ";
    private final String _body = "<html><head></head><body><p>WOW</p></body></html>";
    private String _resultChunked = "HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nContent-Length: " + "<html><head></head><body><p>WOW</p></body></html>".length() + "\r\n" + "Transfer-Encoding: chunked" + "\r\n" + "\r\n";
    private String _resultNotChunked = "HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nContent-Length: " + "<html><head></head><body><p>WOW</p></body></html>".length() + "\r\n" + "\r\n";
    private HttpResponse _resp = null;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this._resp = new HttpResponse();
        this._resp.setStatusLine(new HttpVersion(1, 1), 200);
        this._resp.setHeader(new Header("Content-Type", "text/plain"));
        this._resp.setBody((MuleMessage)new DefaultMuleMessage((Object)"<html><head></head><body><p>WOW</p></body></html>", muleContext));
    }

    public void testTransformChunked() throws Exception {
        HttpResponseToString trasf = new HttpResponseToString();
        trasf.setReturnDataType(DataTypeFactory.STRING);
        this._resp.setHeader(new Header("Transfer-Encoding", "chunked"));
        this._resultChunked = this._resultChunked + "31\r\n<html><head></head><body><p>WOW</p></body></html>\r\n0\r\n\r\n";
        String trasfRes = (String)trasf.doTransform((Object)this._resp, "ISO-8859-1");
        HttpResponseToStringTestCase.assertEquals((String)this._resultChunked, (String)trasfRes);
    }

    public void testTransformNotChunked() throws Exception {
        HttpResponseToString trasf = new HttpResponseToString();
        trasf.setReturnDataType(DataTypeFactory.STRING);
        this._resultNotChunked = this._resultNotChunked + "<html><head></head><body><p>WOW</p></body></html>";
        String trasfRes = (String)trasf.doTransform((Object)this._resp, "ISO-8859-1");
        HttpResponseToStringTestCase.assertEquals((String)this._resultNotChunked, (String)trasfRes);
    }

    public void testTransformException() {
        try {
            HttpResponseToString trasf = new HttpResponseToString();
            trasf.doTransform((Object)this._resp, "ISO-8859-20");
            HttpResponseToStringTestCase.fail();
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }
}

