/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.httpclient.cookie.MalformedCookieException;
import org.apache.commons.httpclient.cookie.NetscapeDraftSpec;
import org.apache.commons.httpclient.cookie.RFC2109Spec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.http.Cookies;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.ServerCookie;
import org.mule.api.MuleEvent;
import org.mule.transport.http.CookieStorageType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieHelper {
    private static final String DEFAULT_URI_STRING = "http://localhost:80/";
    protected static final Log logger = LogFactory.getLog(CookieHelper.class);

    private CookieHelper() {
    }

    public static CookieSpec getCookieSpec(String spec) {
        if (spec != null && spec.equalsIgnoreCase("netscape")) {
            return new NetscapeDraftSpec();
        }
        return new RFC2109Spec();
    }

    public static String getCookiePolicy(String spec) {
        if (spec != null && spec.equalsIgnoreCase("netscape")) {
            return "netscape";
        }
        return "rfc2109";
    }

    public static Cookie[] parseCookiesAsAClient(Header cookieHeader, String spec) throws MalformedCookieException {
        return CookieHelper.parseCookiesAsAClient(cookieHeader.getValue(), spec, null);
    }

    public static Cookie[] parseCookiesAsAClient(String cookieHeaderValue, String spec) throws MalformedCookieException {
        return CookieHelper.parseCookiesAsAClient(cookieHeaderValue, spec, null);
    }

    public static Cookie[] parseCookiesAsAClient(Header cookieHeader, String spec, URI uri) throws MalformedCookieException {
        return CookieHelper.parseCookiesAsAClient(cookieHeader.getValue(), spec, uri);
    }

    public static Cookie[] parseCookiesAsAClient(String cookieHeaderValue, String spec, URI uri) throws MalformedCookieException {
        if (uri == null) {
            try {
                uri = new URI(DEFAULT_URI_STRING);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("This should have not happened", e);
            }
        }
        CookieSpec cookieSpec = CookieHelper.getCookieSpec(spec);
        boolean secure = uri.getScheme() != null && uri.getScheme().equalsIgnoreCase("https");
        String host = uri.getHost();
        int port = CookieHelper.getPortFromURI(uri);
        String path = uri.getPath();
        return cookieSpec.parse(host, port, path, secure, cookieHeaderValue);
    }

    private static int getPortFromURI(URI uri) throws MalformedCookieException {
        int port = uri.getPort();
        if (port < 0) {
            String scheme = uri.getScheme();
            if (scheme.equalsIgnoreCase("https")) {
                port = 443;
            } else if (scheme.equalsIgnoreCase("http")) {
                port = 80;
            } else {
                String message = String.format("The uri (%1s) does not specify a port and no default is available for its scheme (%2s).", uri, scheme);
                throw new MalformedCookieException(message);
            }
        }
        return port;
    }

    public static Cookie[] parseCookiesAsAServer(Header header, URI uri) {
        return CookieHelper.parseCookiesAsAServer(header.getValue(), uri);
    }

    public static Cookie[] parseCookiesAsAServer(String headerValue, URI uri) {
        MimeHeaders mimeHeaders = new MimeHeaders();
        mimeHeaders.addValue("Cookie").setBytes(headerValue.getBytes(), 0, headerValue.length());
        Cookies cs = new Cookies(mimeHeaders);
        Cookie[] cookies = new Cookie[cs.getCookieCount()];
        for (int i = 0; i < cs.getCookieCount(); ++i) {
            ServerCookie serverCookie = cs.getCookie(i);
            cookies[i] = CookieHelper.transformServerCookieToClientCookie(serverCookie);
            if (uri == null) continue;
            cookies[i].setSecure(uri.getScheme() != null && uri.getScheme().equalsIgnoreCase("https"));
            cookies[i].setDomain(uri.getHost());
            cookies[i].setPath(uri.getPath());
        }
        return cookies;
    }

    protected static Cookie transformServerCookieToClientCookie(ServerCookie serverCookie) {
        Cookie clientCookie = new Cookie(serverCookie.getDomain().toString(), serverCookie.getName().toString(), serverCookie.getValue().toString(), serverCookie.getPath().toString(), serverCookie.getMaxAge(), serverCookie.getSecure());
        clientCookie.setComment(serverCookie.getComment().toString());
        clientCookie.setVersion(serverCookie.getVersion());
        return clientCookie;
    }

    public static String formatCookieForASetCookieHeader(Cookie cookie) {
        StringBuffer sb = new StringBuffer();
        ServerCookie.appendCookieValue((StringBuffer)sb, (int)cookie.getVersion(), (String)cookie.getName(), (String)cookie.getValue(), (String)cookie.getPath(), (String)cookie.getDomain(), (String)cookie.getComment(), (int)-1, (boolean)cookie.getSecure());
        String cookieForASetCookieHeader = sb.toString();
        return cookieForASetCookieHeader;
    }

    public static void addCookiesToClient(HttpClient client, Object cookiesObject, String policy, MuleEvent event, URI destinationUri) {
        CookieStorageType.resolveCookieStorageType(cookiesObject).addCookiesToClient(client, cookiesObject, policy, event, destinationUri);
    }

    public static Object putAndMergeCookie(Object preExistentCookies, String cookieName, String cookieValue) {
        return CookieStorageType.resolveCookieStorageType(preExistentCookies).putAndMergeCookie(preExistentCookies, cookieName, cookieValue);
    }

    public static Object putAndMergeCookie(Object preExistentCookies, Cookie[] newCookiesArray) {
        return CookieStorageType.resolveCookieStorageType(preExistentCookies).putAndMergeCookie(preExistentCookies, newCookiesArray);
    }

    public static Object putAndMergeCookie(Object preExistentCookies, Map<String, String> newCookiesMap) {
        return CookieStorageType.resolveCookieStorageType(preExistentCookies).putAndMergeCookie(preExistentCookies, newCookiesMap);
    }

    public static String getCookieValueFromCookies(Object cookiesObject, String cookieName) {
        return CookieStorageType.resolveCookieStorageType(cookiesObject).getCookieValueFromCookies(cookiesObject, cookieName);
    }

    public static Cookie[] asArrayOfCookies(Object cookiesObject) {
        return CookieStorageType.resolveCookieStorageType(cookiesObject).asArrayOfCookies(cookiesObject);
    }
}

