/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.model.SessionException;
import org.mule.api.transport.SessionHandler;
import org.mule.config.i18n.MessageFactory;
import org.mule.transport.http.CookieHelper;
import org.mule.util.Base64;
import org.mule.util.SerializationUtils;

public class HttpSessionHandler
implements SessionHandler {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    public MuleSession retrieveSessionInfoFromMessage(MuleMessage message) throws MuleException {
        byte[] serializedSession;
        Object cookiesObject = message.getOutboundProperty("cookies");
        String cookieName = "MULE_SESSION";
        String cookieValue = CookieHelper.getCookieValueFromCookies(cookiesObject, "MULE_SESSION");
        MuleSession session = null;
        if (cookieValue != null && (serializedSession = Base64.decode((String)cookieValue)) != null) {
            session = (MuleSession)SerializationUtils.deserialize((byte[])serializedSession, (MuleContext)message.getMuleContext());
        }
        return session;
    }

    @Deprecated
    public void retrieveSessionInfoFromMessage(MuleMessage message, MuleSession session) throws MuleException {
        session = this.retrieveSessionInfoFromMessage(message);
    }

    public void storeSessionInfoToMessage(MuleSession session, MuleMessage message) throws MuleException {
        String serializedEncodedSession;
        byte[] serializedSession = SerializationUtils.serialize((Serializable)session);
        try {
            serializedEncodedSession = Base64.encodeBytes((byte[])serializedSession, (int)8);
        }
        catch (IOException e) {
            throw new SessionException(MessageFactory.createStaticMessage((String)"Unable to serialize MuleSession"), (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding serialized and base64-encoded Session header to message: " + serializedEncodedSession));
        }
        Object preExistentCookies = message.getOutboundProperty("cookies");
        String cookieName = "MULE_SESSION";
        String cookieValue = serializedEncodedSession;
        Object mergedCookies = CookieHelper.putAndMergeCookie(preExistentCookies, "MULE_SESSION", cookieValue);
        message.setOutboundProperty("cookies", mergedCookies);
    }

    @Deprecated
    public String getSessionIDKey() {
        return "ID";
    }
}

