/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.routing.filter.Filter;
import org.mule.transport.http.AbstractNamespaceHandlerTestCase;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpPollingConnector;
import org.mule.transport.http.filters.HttpRequestWildcardFilter;
import org.mule.transport.http.transformers.HttpClientMethodResponseToObject;
import org.mule.transport.http.transformers.HttpResponseToString;
import org.mule.transport.http.transformers.MuleMessageToHttpResponse;
import org.mule.transport.http.transformers.ObjectToHttpClientMethodRequest;

public class HttpNamespaceHandlerTestCase
extends AbstractNamespaceHandlerTestCase {
    public HttpNamespaceHandlerTestCase() {
        super("http");
    }

    public void testConnectorProperties() {
        HttpConnector connector = (HttpConnector)muleContext.getRegistry().lookupConnector("httpConnector");
        this.testBasicProperties(connector);
    }

    public void testPollingProperties() {
        HttpPollingConnector connector = (HttpPollingConnector)muleContext.getRegistry().lookupConnector("polling");
        HttpNamespaceHandlerTestCase.assertNotNull((Object)connector);
        HttpNamespaceHandlerTestCase.assertEquals((long)3456L, (long)connector.getPollingFrequency());
        HttpNamespaceHandlerTestCase.assertFalse((boolean)connector.isCheckEtag());
        HttpNamespaceHandlerTestCase.assertFalse((boolean)connector.isDiscardEmptyContent());
    }

    public void testTransformersOnEndpoints() throws Exception {
        Object transformer1 = this.lookupInboundEndpoint("ep1").getTransformers().get(0);
        HttpNamespaceHandlerTestCase.assertNotNull(transformer1);
        HttpNamespaceHandlerTestCase.assertEquals(HttpClientMethodResponseToObject.class, transformer1.getClass());
        Object transformer2 = this.lookupInboundEndpoint("ep2").getTransformers().get(0);
        HttpNamespaceHandlerTestCase.assertNotNull(transformer2);
        HttpNamespaceHandlerTestCase.assertEquals(HttpResponseToString.class, transformer2.getClass());
        Object transformer3 = this.lookupInboundEndpoint("ep3").getTransformers().get(0);
        HttpNamespaceHandlerTestCase.assertNotNull(transformer3);
        HttpNamespaceHandlerTestCase.assertEquals(MuleMessageToHttpResponse.class, transformer3.getClass());
        Object transformer4 = this.lookupInboundEndpoint("ep4").getTransformers().get(0);
        HttpNamespaceHandlerTestCase.assertNotNull(transformer4);
        HttpNamespaceHandlerTestCase.assertEquals(ObjectToHttpClientMethodRequest.class, transformer4.getClass());
    }

    public void testFiltersOnEndpoints() throws Exception {
        Filter filter = this.lookupInboundEndpoint("ep5").getFilter();
        HttpNamespaceHandlerTestCase.assertNotNull((Object)filter);
        HttpNamespaceHandlerTestCase.assertEquals(HttpRequestWildcardFilter.class, filter.getClass());
        HttpRequestWildcardFilter requestWildcardFilter = (HttpRequestWildcardFilter)filter;
        HttpNamespaceHandlerTestCase.assertEquals((String)"foo*", (String)requestWildcardFilter.getPattern());
    }

    private InboundEndpoint lookupInboundEndpoint(String endpointName) throws Exception {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint(endpointName);
        HttpNamespaceHandlerTestCase.assertNotNull((Object)endpoint);
        return endpoint;
    }
}

