/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import org.mule.transport.http.AbstractNamespaceHandlerTestCase;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpsConnector;
import org.mule.transport.http.HttpsPollingConnector;

public class HttpsNamespaceHandlerTestCase
extends AbstractNamespaceHandlerTestCase {
    public HttpsNamespaceHandlerTestCase() {
        super("https");
    }

    public void testConnectorProperties() {
        HttpsConnector connector = (HttpsConnector)muleContext.getRegistry().lookupConnector("httpsConnector");
        this.testBasicProperties((HttpConnector)connector);
        HttpsNamespaceHandlerTestCase.assertTrue((boolean)connector.getKeyStore().endsWith("/serverKeystore"));
        HttpsNamespaceHandlerTestCase.assertEquals((String)"muleserver", (String)connector.getKeyAlias());
        HttpsNamespaceHandlerTestCase.assertEquals((String)"mulepassword", (String)connector.getKeyPassword());
        HttpsNamespaceHandlerTestCase.assertEquals((String)"mulepassword", (String)connector.getKeyStorePassword());
        HttpsNamespaceHandlerTestCase.assertTrue((boolean)connector.getClientKeyStore().endsWith("/clientKeystore"));
        HttpsNamespaceHandlerTestCase.assertEquals((String)"mulepassword", (String)connector.getClientKeyStorePassword());
        HttpsNamespaceHandlerTestCase.assertTrue((boolean)connector.getTrustStore().endsWith("/trustStore"));
        HttpsNamespaceHandlerTestCase.assertEquals((String)"mulepassword", (String)connector.getTrustStorePassword());
        HttpsNamespaceHandlerTestCase.assertTrue((boolean)connector.isExplicitTrustStoreOnly());
        HttpsNamespaceHandlerTestCase.assertTrue((boolean)connector.isRequireClientAuthentication());
        HttpsNamespaceHandlerTestCase.assertEquals((String)"foo", (String)connector.getProtocolHandler());
    }

    public void testPollingProperties() {
        HttpsPollingConnector connector = (HttpsPollingConnector)muleContext.getRegistry().lookupConnector("polling");
        HttpsNamespaceHandlerTestCase.assertNotNull((Object)connector);
        HttpsNamespaceHandlerTestCase.assertEquals((long)3456L, (long)connector.getPollingFrequency());
        HttpsNamespaceHandlerTestCase.assertFalse((boolean)connector.isCheckEtag());
        HttpsNamespaceHandlerTestCase.assertFalse((boolean)connector.isDiscardEmptyContent());
    }
}

