/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import junit.framework.Assert;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transport.http.MuleHostConfiguration;

public class MuleHostConfigurationTestCase
extends AbstractMuleTestCase {
    private static final String HTTPX = "httpx";

    public void testSetHostViaUri() throws Exception {
        MuleHostConfiguration hostConfig = this.createHostConfiguration();
        URI uri = new URI("http://www.mulesoft.org:8080", false);
        hostConfig.setHost(uri);
        this.assertMockSocketFactory((HostConfiguration)hostConfig);
        MuleHostConfigurationTestCase.assertEquals((String)"www.mulesoft.org", (String)hostConfig.getHost());
        MuleHostConfigurationTestCase.assertEquals((int)8080, (int)hostConfig.getPort());
    }

    public void testSetHostViaUriWithDifferentProtocol() throws Exception {
        new DifferentProtocolTemplate(){

            @Override
            protected void doTest() throws Exception {
                MuleHostConfiguration hostConfig = MuleHostConfigurationTestCase.this.createHostConfiguration();
                URI uri = new URI("httpx://www.mulesoft.org:8080", false);
                hostConfig.setHost(uri);
                Assert.assertTrue((boolean)(hostConfig.getProtocol().getSocketFactory() instanceof DefaultProtocolSocketFactory));
                Assert.assertEquals((String)"www.mulesoft.org", (String)hostConfig.getHost());
                Assert.assertEquals((int)8080, (int)hostConfig.getPort());
            }
        }.test();
    }

    public void testSetHostViaHttpHost() {
        MuleHostConfiguration hostConfig = this.createHostConfiguration();
        HttpHost host = new HttpHost("www.mulesoft.org", 8080);
        hostConfig.setHost(host);
        this.assertMockSocketFactory((HostConfiguration)hostConfig);
        MuleHostConfigurationTestCase.assertEquals((String)"www.mulesoft.org", (String)hostConfig.getHost());
        MuleHostConfigurationTestCase.assertEquals((int)8080, (int)hostConfig.getPort());
    }

    public void testSetHostViaHostAndPortAndProtocolName() {
        MuleHostConfiguration hostConfig = this.createHostConfiguration();
        hostConfig.setHost("www.mulesoft.org", 8080, "http");
        this.assertMockSocketFactory((HostConfiguration)hostConfig);
        MuleHostConfigurationTestCase.assertEquals((String)"www.mulesoft.org", (String)hostConfig.getHost());
        MuleHostConfigurationTestCase.assertEquals((int)8080, (int)hostConfig.getPort());
    }

    public void testSetHostViaHostAndPortAndProtocolNameWithDifferentProtocol() throws Exception {
        new DifferentProtocolTemplate(){

            @Override
            protected void doTest() throws Exception {
                MuleHostConfiguration hostConfig = MuleHostConfigurationTestCase.this.createHostConfiguration();
                hostConfig.setHost("www.mulesoft.org", 8080, MuleHostConfigurationTestCase.HTTPX);
                MuleHostConfigurationTestCase.this.assertDefaultSocketFactory((HostConfiguration)hostConfig);
                Assert.assertEquals((String)"www.mulesoft.org", (String)hostConfig.getHost());
                Assert.assertEquals((int)8080, (int)hostConfig.getPort());
            }
        }.test();
    }

    public void testSetHostViaHostAndVirtualHostAndPortAndProtocol() {
        MuleHostConfiguration hostConfig = this.createHostConfiguration();
        Protocol protocol = Protocol.getProtocol((String)"http");
        hostConfig.setHost("www.mulesoft.org", "www.mulesoft.com", 8080, protocol);
        this.assertMockSocketFactory((HostConfiguration)hostConfig);
        MuleHostConfigurationTestCase.assertEquals((String)"www.mulesoft.org", (String)hostConfig.getHost());
        MuleHostConfigurationTestCase.assertEquals((int)8080, (int)hostConfig.getPort());
        MuleHostConfigurationTestCase.assertEquals((String)"www.mulesoft.com", (String)hostConfig.getVirtualHost());
    }

    public void testSetHostViaHostAndVirtualHostAndPortAndProtocolWithDifferentProtocol() throws Exception {
        new DifferentProtocolTemplate(){

            @Override
            protected void doTest() throws Exception {
                MuleHostConfiguration hostConfig = MuleHostConfigurationTestCase.this.createHostConfiguration();
                Protocol protocol = Protocol.getProtocol((String)MuleHostConfigurationTestCase.HTTPX);
                hostConfig.setHost("www.mulesoft.org", "www.mulesoft.com", 8080, protocol);
                MuleHostConfigurationTestCase.this.assertDefaultSocketFactory((HostConfiguration)hostConfig);
                Assert.assertEquals((String)"www.mulesoft.org", (String)hostConfig.getHost());
                Assert.assertEquals((int)8080, (int)hostConfig.getPort());
                Assert.assertEquals((String)"www.mulesoft.com", (String)hostConfig.getVirtualHost());
            }
        }.test();
    }

    public void testSetHostViaHostAndPort() {
        MuleHostConfiguration hostConfig = this.createHostConfiguration();
        hostConfig.setHost("www.mulesoft.org", 8080);
        this.assertMockSocketFactory((HostConfiguration)hostConfig);
        MuleHostConfigurationTestCase.assertEquals((String)"www.mulesoft.org", (String)hostConfig.getHost());
        MuleHostConfigurationTestCase.assertEquals((int)8080, (int)hostConfig.getPort());
    }

    public void testSetHostViaHost() {
        MuleHostConfiguration hostConfig = this.createHostConfiguration();
        hostConfig.setHost("www.mulesoft.org");
        MuleHostConfigurationTestCase.assertEquals((String)"www.mulesoft.org", (String)hostConfig.getHost());
        this.assertMockSocketFactory((HostConfiguration)hostConfig);
    }

    public void testClone() {
        MuleHostConfiguration hostConfig = this.createHostConfiguration();
        HostConfiguration clone = (HostConfiguration)hostConfig.clone();
        this.assertMockSocketFactory(clone);
    }

    private MuleHostConfiguration createHostConfiguration() {
        MuleHostConfiguration hostConfig = new MuleHostConfiguration();
        MockSecureProtocolFactory socketFactory = new MockSecureProtocolFactory();
        Protocol protocol = new Protocol("http", (ProtocolSocketFactory)socketFactory, 80);
        hostConfig.setHost("localhost", 80, protocol);
        this.assertMockSocketFactory((HostConfiguration)hostConfig);
        return hostConfig;
    }

    private void assertMockSocketFactory(HostConfiguration hostConfig) {
        MuleHostConfigurationTestCase.assertTrue((boolean)(hostConfig.getProtocol().getSocketFactory() instanceof MockSecureProtocolFactory));
    }

    private void assertDefaultSocketFactory(HostConfiguration hostConfig) {
        MuleHostConfigurationTestCase.assertTrue((boolean)(hostConfig.getProtocol().getSocketFactory() instanceof DefaultProtocolSocketFactory));
    }

    private static class MockSecureProtocolFactory
    implements SecureProtocolSocketFactory {
        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            throw new UnsupportedOperationException();
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            throw new UnsupportedOperationException();
        }

        public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
            throw new UnsupportedOperationException();
        }

        public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class DifferentProtocolTemplate {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void test() throws Exception {
            try {
                Protocol httpxProtocol = new Protocol(MuleHostConfigurationTestCase.HTTPX, (ProtocolSocketFactory)new DefaultProtocolSocketFactory(), 81);
                Protocol.registerProtocol((String)MuleHostConfigurationTestCase.HTTPX, (Protocol)httpxProtocol);
                this.doTest();
            }
            finally {
                Protocol.unregisterProtocol((String)MuleHostConfigurationTestCase.HTTPX);
            }
        }

        protected abstract void doTest() throws Exception;
    }
}

