/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import org.mule.api.DefaultMuleException;
import org.mule.api.routing.RoutingException;
import org.mule.api.security.SecurityException;
import org.mule.api.security.UnauthorisedException;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.MessageFactory;
import org.mule.tck.AbstractMuleTestCase;

public class StatusCodeMappingsTestCase
extends AbstractMuleTestCase {
    public void testErrorMappings() {
        String code = ExceptionHelper.getErrorMapping((String)"http", RoutingException.class);
        StatusCodeMappingsTestCase.assertEquals((String)"500", (String)code);
        code = ExceptionHelper.getErrorMapping((String)"HTTP", SecurityException.class);
        StatusCodeMappingsTestCase.assertEquals((String)"403", (String)code);
        code = ExceptionHelper.getErrorMapping((String)"http", UnauthorisedException.class);
        StatusCodeMappingsTestCase.assertEquals((String)"401", (String)code);
        code = ExceptionHelper.getErrorMapping((String)"blah", DefaultMuleException.class);
        StatusCodeMappingsTestCase.assertEquals((String)String.valueOf(new DefaultMuleException(MessageFactory.createStaticMessage((String)"test")).getExceptionCode()), (String)code);
    }

    public void testHttpsErrorMappings() {
        String code = ExceptionHelper.getErrorMapping((String)"httpS", RoutingException.class);
        StatusCodeMappingsTestCase.assertEquals((String)"500", (String)code);
        code = ExceptionHelper.getErrorMapping((String)"HTTPS", SecurityException.class);
        StatusCodeMappingsTestCase.assertEquals((String)"403", (String)code);
        code = ExceptionHelper.getErrorMapping((String)"https", UnauthorisedException.class);
        StatusCodeMappingsTestCase.assertEquals((String)"401", (String)code);
    }
}

