/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.mule.module.client.MuleClient;
import org.mule.transport.http.functional.AbstractMockHttpServerTestCase;
import org.mule.transport.http.functional.MockHttpServer;

public class HttpCookieTestCase
extends AbstractMockHttpServerTestCase {
    private static final String COOKIE_HEADER = "Cookie:";
    private CountDownLatch latch = new CountDownLatch(1);
    private boolean cookieFound = false;
    private List<String> cookieHeaders = new ArrayList<String>();

    protected String getConfigResources() {
        return "http-cookie-test.xml";
    }

    protected int getNumPortsToFind() {
        return 1;
    }

    @Override
    protected MockHttpServer getHttpServer(CountDownLatch serverStartLatch) {
        return new SimpleHttpServer((Integer)this.getPorts().get(0), serverStartLatch, this.latch);
    }

    public void testCookies() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("COOKIE_HEADER", "MYCOOKIE");
        MuleClient client = new MuleClient(muleContext);
        client.dispatch("vm://vm-in", (Object)"foobar", properties);
        HttpCookieTestCase.assertTrue((boolean)this.latch.await(5000L, TimeUnit.MILLISECONDS));
        HttpCookieTestCase.assertTrue((boolean)this.cookieFound);
        HttpCookieTestCase.assertEquals((int)3, (int)this.cookieHeaders.size());
        this.assertThereIsCookieWithThisContent("Cookie: $Version=0; customCookie=yes", this.cookieHeaders);
        this.assertThereIsCookieWithThisContent("Cookie: $Version=0; expressionCookie=MYCOOKIE", this.cookieHeaders);
        this.assertThereIsCookieWithThisContent("MULE_SESSION=", this.cookieHeaders);
    }

    private void assertThereIsCookieWithThisContent(String content, List<String> listOfRawCookies) {
        for (String rawCookie : listOfRawCookies) {
            if (rawCookie == null || !rawCookie.contains(content)) continue;
            return;
        }
        HttpCookieTestCase.fail((String)("There should be a cookie with content '" + content + "': " + listOfRawCookies));
    }

    private class SimpleHttpServer
    extends MockHttpServer {
        public SimpleHttpServer(int listenPort, CountDownLatch startupLatch, CountDownLatch testCompleteLatch) {
            super(listenPort, startupLatch, testCompleteLatch);
        }

        @Override
        protected void readHttpRequest(BufferedReader reader) throws Exception {
            String line = reader.readLine();
            while (line != null) {
                if (line.indexOf(HttpCookieTestCase.COOKIE_HEADER) > -1) {
                    HttpCookieTestCase.this.cookieFound = true;
                    HttpCookieTestCase.this.cookieHeaders.add(line);
                }
                if ((line = reader.readLine()).trim().length() != 0) continue;
                line = null;
            }
        }
    }
}

