/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.transport.http.functional.HttpFunctionalTestCase;

public class HttpEncodingFunctionalTestCase
extends HttpFunctionalTestCase {
    protected static String TEST_MESSAGE = "Test Http Request (R\u00ef\u00bf\u00bddgr\u00ef\u00bf\u00bdd), 57 = \u06f7\u06f5 in Arabic";
    private static String TEST_JAPANESE_MESSAGE = "\u3042";

    public HttpEncodingFunctionalTestCase() {
        this.setDisposeManagerPerSuite(true);
    }

    @Override
    protected String getConfigResources() {
        return "http-encoding-test.xml";
    }

    @Override
    public void testSend() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> messageProperties = new HashMap<String, String>();
        messageProperties.put("Content-Type", this.getSendEncoding());
        MuleMessage reply = client.send("clientEndpoint", (Object)TEST_MESSAGE, messageProperties);
        HttpEncodingFunctionalTestCase.assertNotNull((Object)reply);
        HttpEncodingFunctionalTestCase.assertEquals((Object)"200", (Object)reply.getInboundProperty("http.status"));
        HttpEncodingFunctionalTestCase.assertEquals((String)"text/baz;charset=UTF-16BE", (String)((String)reply.getInboundProperty("Content-Type")));
        HttpEncodingFunctionalTestCase.assertEquals((String)"UTF-16BE", (String)reply.getEncoding());
        HttpEncodingFunctionalTestCase.assertEquals((String)(TEST_MESSAGE + " Received"), (String)reply.getPayloadAsString());
    }

    public void testPostEncodingUsAscii() throws Exception {
        this.runPostEncodingTest("US-ASCII", "A");
    }

    public void testPostEncodingUtf8() throws Exception {
        this.runPostEncodingTest("UTF-8", "A");
        this.runPostEncodingTest("UTF-8", TEST_JAPANESE_MESSAGE);
    }

    public void _testPostEncodingShiftJs() throws Exception {
        this.runPostEncodingTest("Shift_JIS", TEST_JAPANESE_MESSAGE);
    }

    public void _testPostEncodingWindows31J() throws Exception {
        this.runPostEncodingTest("Windows-31J", TEST_JAPANESE_MESSAGE);
    }

    public void _testPostEncodingEucJp() throws Exception {
        this.runPostEncodingTest("EUC-JP", TEST_JAPANESE_MESSAGE);
    }

    public void _testGetEncodingUsAscii() throws Exception {
        this.runGetEncodingTest("US-ASCII", "A");
    }

    public void _testGetEncodingUtf8() throws Exception {
        this.runGetEncodingTest("UTF-8", "A");
        this.runGetEncodingTest("UTF-8", TEST_JAPANESE_MESSAGE);
    }

    public void _testGetEncodingShiftJs() throws Exception {
        this.runGetEncodingTest("Shift_JIS", TEST_JAPANESE_MESSAGE);
    }

    public void _testGetEncodingWindows31J() throws Exception {
        this.runGetEncodingTest("Windows-31J", TEST_JAPANESE_MESSAGE);
    }

    public void _testGetEncodingEucJp() throws Exception {
        this.runGetEncodingTest("EUC-JP", TEST_JAPANESE_MESSAGE);
    }

    private void runPostEncodingTest(String encoding, String payload) throws Exception {
        MuleMessage reply = this.runEncodingTest(encoding, payload, "POST");
        HttpEncodingFunctionalTestCase.assertEquals((String)(payload + " Received"), (String)reply.getPayloadAsString());
    }

    private void runGetEncodingTest(String encoding, String payload) throws Exception {
        MuleMessage reply = this.runEncodingTest(encoding, payload, "GET");
        String expectedReplyMessage = "/" + encoding + "?body=" + URLEncoder.encode(payload, encoding);
        HttpEncodingFunctionalTestCase.assertEquals((String)(expectedReplyMessage + " Received"), (String)reply.getPayloadAsString());
    }

    private MuleMessage runEncodingTest(String encoding, String payload, String httpMethod) throws Exception {
        Map<String, Object> messageProperties = this.createMessageProperties(encoding, httpMethod);
        LocalMuleClient client = muleContext.getClient();
        String endpointUri = "clientEndpoint." + encoding;
        MuleMessage reply = client.send(endpointUri, (Object)payload, messageProperties);
        HttpEncodingFunctionalTestCase.assertNotNull((Object)reply);
        HttpEncodingFunctionalTestCase.assertEquals((Object)"200", (Object)reply.getInboundProperty("http.status"));
        Object contentTypeHeader = reply.getInboundProperty("Content-Type");
        HttpEncodingFunctionalTestCase.assertEquals((Object)("text/plain;charset=" + encoding), (Object)contentTypeHeader);
        HttpEncodingFunctionalTestCase.assertEquals((String)encoding, (String)reply.getEncoding());
        return reply;
    }

    private Map<String, Object> createMessageProperties(String encoding, String httpMethod) {
        HashMap<String, Object> messageProperties = new HashMap<String, Object>();
        String contentType = "text/plain;charset=" + encoding;
        messageProperties.put("Content-Type", contentType);
        messageProperties.put("http.method", httpMethod);
        return messageProperties;
    }

    protected String getSendEncoding() {
        return "text/plain;charset=UTF-8";
    }
}

