/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.LocaleMessageHandler;
import org.mule.module.client.MuleClient;
import org.mule.tck.DynamicPortTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.transformer.AbstractTransformer;
import org.mule.util.SystemUtils;
import org.mule.util.concurrent.Latch;

public class HttpEncodingNonAsciiFunctionalTestCase
extends DynamicPortTestCase {
    private static final String ENCODING_JP = "ISO-2022-JP";
    private static final String FORM_ENCODED_CONTENT_TYPE_HEADER = "application/x-www-form-urlencoded; charset=ISO-2022-JP";
    private static final String PLAIN_CONTENT_TYPE_HEADER = "text/plain; charset=ISO-2022-JP";

    protected boolean isDisabledInThisEnvironment() {
        return SystemUtils.isIbmJDK();
    }

    protected String getConfigResources() {
        return "http-encoding-non-ascii-test.xml";
    }

    protected int getNumPortsToFind() {
        return 1;
    }

    public void testSendViaGET() throws Exception {
        Latch latch = new Latch();
        this.setupAssertIncomingMessage("GET", latch, PLAIN_CONTENT_TYPE_HEADER);
        String testMessage = this.getTestMessage(Locale.JAPAN);
        String encodedPayload = URLEncoder.encode(testMessage, ENCODING_JP);
        String url = String.format("http://localhost:%1d/get?%2s=%3s", this.getPorts().get(0), "body", encodedPayload);
        GetMethod method = new GetMethod(url);
        method.addRequestHeader("Content-Type", PLAIN_CONTENT_TYPE_HEADER);
        int status = new HttpClient().executeMethod((HttpMethod)method);
        HttpEncodingNonAsciiFunctionalTestCase.assertEquals((int)200, (int)status);
        HttpEncodingNonAsciiFunctionalTestCase.assertTrue((boolean)latch.await(5000L, TimeUnit.MILLISECONDS));
        String expected = testMessage + " Received";
        String response = method.getResponseBodyAsString();
        HttpEncodingNonAsciiFunctionalTestCase.assertEquals((String)expected, (String)response);
        Header responseContentType = method.getResponseHeader("Content-Type");
        HttpEncodingNonAsciiFunctionalTestCase.assertEquals((String)"text/plain;charset=EUC-JP", (String)responseContentType.getValue());
    }

    public void testSendViaPOST() throws Exception {
        String payload = this.getTestMessage(Locale.JAPAN);
        HashMap<String, Object> messageProperties = new HashMap<String, Object>();
        messageProperties.put("MULE_ENCODING", ENCODING_JP);
        this.doTestSend("POST", payload, messageProperties, PLAIN_CONTENT_TYPE_HEADER);
    }

    public void testSendViaPostMap() throws Exception {
        HashMap<String, String> messagePayload = new HashMap<String, String>();
        messagePayload.put("body", this.getTestMessage(Locale.JAPAN));
        HashMap<String, Object> messageProperties = new HashMap<String, Object>();
        messageProperties.put("MULE_ENCODING", ENCODING_JP);
        this.doTestSend("POSTMap", messagePayload, messageProperties, FORM_ENCODED_CONTENT_TYPE_HEADER);
    }

    private void doTestSend(String method, Object messagePayload, Map<String, Object> messageProperties, String expectedContentTypeHeader) throws Exception {
        Latch latch = new Latch();
        this.setupAssertIncomingMessage(method, latch, expectedContentTypeHeader);
        MuleClient client = new MuleClient(muleContext);
        MuleMessage reply = client.send("vm://sendBy" + method, messagePayload, messageProperties);
        HttpEncodingNonAsciiFunctionalTestCase.assertTrue((boolean)latch.await(5000L, TimeUnit.MILLISECONDS));
        HttpEncodingNonAsciiFunctionalTestCase.assertNotNull((Object)reply);
        HttpEncodingNonAsciiFunctionalTestCase.assertEquals((Object)expectedContentTypeHeader, (Object)reply.getInvocationProperty("Content-Type"));
        HttpEncodingNonAsciiFunctionalTestCase.assertEquals((String)"EUC-JP", (String)reply.getEncoding());
        HttpEncodingNonAsciiFunctionalTestCase.assertEquals((String)(this.getTestMessage(Locale.JAPAN) + " Received"), (String)reply.getPayloadAsString());
    }

    private void setupAssertIncomingMessage(String method, final Latch latch, final String expectedContentTypeHeader) throws Exception {
        FunctionalTestComponent ftc = this.getFunctionalTestComponent("testReceive" + method);
        ftc.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object serviceComponent) throws Exception {
                MuleMessage message = context.getMessage();
                Assert.assertEquals((Object)expectedContentTypeHeader, (Object)message.getInboundProperty("Content-Type", null));
                Assert.assertEquals((String)HttpEncodingNonAsciiFunctionalTestCase.ENCODING_JP, (String)message.getEncoding());
                Object payload = message.getPayload();
                if (payload instanceof String) {
                    Assert.assertEquals((Object)HttpEncodingNonAsciiFunctionalTestCase.this.getTestMessage(Locale.JAPAN), (Object)payload);
                } else {
                    Assert.fail();
                }
                latch.countDown();
            }
        });
    }

    String getTestMessage(Locale locale) {
        return LocaleMessageHandler.getString((String)"test-data", (Locale)locale, (String)"HttpEncodingNonAsciiFunctionalTestCase.getMessage", (Object[])new Object[0]);
    }

    public static class ParamMapToString
    extends AbstractTransformer {
        protected Object doTransform(Object src, String outputEncoding) throws TransformerException {
            Map map = (Map)src;
            return map.get("body");
        }
    }
}

