/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.reliability;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.mule.exception.DefaultSystemExceptionStrategy;
import org.mule.routing.filters.WildcardFilter;
import org.mule.tck.DynamicPortTestCase;

public class InboundMessageLossTestCase
extends DynamicPortTestCase {
    protected HttpClient httpClient = new HttpClient();

    protected String getConfigResources() {
        return "reliability/inbound-message-loss.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        ((DefaultSystemExceptionStrategy)muleContext.getExceptionListener()).setRollbackTxFilter(new WildcardFilter("*"));
    }

    public void testNoException() throws Exception {
        HttpMethodBase request = this.createRequest(this.getBaseUri() + "/noException");
        int status = this.httpClient.executeMethod((HttpMethod)request);
        InboundMessageLossTestCase.assertEquals((int)200, (int)status);
        InboundMessageLossTestCase.assertEquals((String)"Here you go", (String)request.getResponseBodyAsString());
    }

    public void testTransformerException() throws Exception {
        HttpMethodBase request = this.createRequest(this.getBaseUri() + "/transformerException");
        int status = this.httpClient.executeMethod((HttpMethod)request);
        InboundMessageLossTestCase.assertEquals((int)500, (int)status);
        InboundMessageLossTestCase.assertTrue((boolean)request.getResponseBodyAsString().contains("Failure"));
    }

    public void testRouterException() throws Exception {
        HttpMethodBase request = this.createRequest(this.getBaseUri() + "/routerException");
        int status = this.httpClient.executeMethod((HttpMethod)request);
        InboundMessageLossTestCase.assertEquals((int)500, (int)status);
        InboundMessageLossTestCase.assertTrue((boolean)request.getResponseBodyAsString().contains("Failure"));
    }

    public void testComponentException() throws Exception {
        HttpMethodBase request = this.createRequest(this.getBaseUri() + "/componentException");
        int status = this.httpClient.executeMethod((HttpMethod)request);
        InboundMessageLossTestCase.assertEquals((int)500, (int)status);
        InboundMessageLossTestCase.assertTrue((boolean)request.getResponseBodyAsString().contains("exception"));
    }

    protected HttpMethodBase createRequest(String uri) {
        return new GetMethod(uri);
    }

    protected String getBaseUri() {
        return "http://localhost:" + this.getPorts().get(0);
    }

    protected int getNumPortsToFind() {
        return 1;
    }
}

