/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.transport.http.CookieHelper;
import org.mule.transport.http.CookieStorageType;

public class CookieHelperTestCase
extends AbstractMuleTestCase {
    private static final String COOKIE_1_NAME = "cookie1";
    private static final String COOKIE_1_ORIGINAL_VALUE = "value1";
    private static final String COOKIE_2_NAME = "cookie2";
    private static final String COOKIE_2_VALUE = "value2";
    private static final String COOKIE_1_NEW_VALUE = "newValue1 That Overrides Previous One";

    @Test
    public void testPutAndMergeCookieObjectMapOfStringString_CookiesInMap_NewCookiesInMap() {
        Map cookiesObject = new HashMap<String, String>();
        cookiesObject.put(COOKIE_1_NAME, COOKIE_1_ORIGINAL_VALUE);
        Assert.assertEquals((long)1L, (long)cookiesObject.size());
        HashMap<String, String> newCookiesMap = new HashMap<String, String>();
        newCookiesMap.put(COOKIE_1_NAME, COOKIE_1_NEW_VALUE);
        newCookiesMap.put(COOKIE_2_NAME, COOKIE_2_VALUE);
        cookiesObject = (Map)CookieHelper.putAndMergeCookie(cookiesObject, newCookiesMap);
        Assert.assertEquals((long)2L, (long)cookiesObject.size());
        Assert.assertEquals((Object)COOKIE_1_NEW_VALUE, cookiesObject.get(COOKIE_1_NAME));
        Assert.assertEquals((Object)COOKIE_2_VALUE, cookiesObject.get(COOKIE_2_NAME));
        Map unModifiedCookiesObject = (Map)CookieHelper.putAndMergeCookie(cookiesObject, (Map)null);
        Assert.assertSame(cookiesObject, (Object)unModifiedCookiesObject);
        Assert.assertEquals((long)2L, (long)cookiesObject.size());
    }

    @Test
    public void testPutAndMergeCookieObjectMapOfStringString_CookiesInArray_NewCookiesInMap() {
        Cookie[] cookiesObject = new Cookie[]{new Cookie(null, COOKIE_1_NAME, COOKIE_1_ORIGINAL_VALUE)};
        HashMap<String, String> newCookiesMap = new HashMap<String, String>();
        newCookiesMap.put(COOKIE_1_NAME, COOKIE_1_NEW_VALUE);
        newCookiesMap.put(COOKIE_2_NAME, COOKIE_2_VALUE);
        cookiesObject = (Cookie[])CookieHelper.putAndMergeCookie((Object)cookiesObject, newCookiesMap);
        Assert.assertEquals((long)2L, (long)cookiesObject.length);
        Assert.assertEquals((Object)COOKIE_1_NAME, (Object)cookiesObject[0].getName());
        Assert.assertEquals((Object)COOKIE_1_NEW_VALUE, (Object)cookiesObject[0].getValue());
        Assert.assertEquals((Object)COOKIE_2_NAME, (Object)cookiesObject[1].getName());
        Assert.assertEquals((Object)COOKIE_2_VALUE, (Object)cookiesObject[1].getValue());
        Cookie[] unModifiedCookiesObject = (Cookie[])CookieHelper.putAndMergeCookie((Object)cookiesObject, (Map)null);
        Assert.assertSame((Object)cookiesObject, (Object)unModifiedCookiesObject);
        Assert.assertEquals((long)2L, (long)cookiesObject.length);
    }

    @Test
    public void testPutAndMergeCookieObjectCookieArray_CookiesInMap_NewCookiesInArray() {
        Map cookiesObject = new HashMap<String, String>();
        cookiesObject.put(COOKIE_1_NAME, COOKIE_1_ORIGINAL_VALUE);
        Assert.assertEquals((long)1L, (long)cookiesObject.size());
        Cookie[] newCookiesArray = new Cookie[]{new Cookie(null, COOKIE_1_NAME, COOKIE_1_NEW_VALUE), new Cookie(null, COOKIE_2_NAME, COOKIE_2_VALUE)};
        cookiesObject = (Map)CookieHelper.putAndMergeCookie(cookiesObject, (Cookie[])newCookiesArray);
        Assert.assertEquals((long)2L, (long)cookiesObject.size());
        Assert.assertEquals((Object)COOKIE_1_NEW_VALUE, cookiesObject.get(COOKIE_1_NAME));
        Assert.assertEquals((Object)COOKIE_2_VALUE, cookiesObject.get(COOKIE_2_NAME));
        Map unModifiedCookiesObject = (Map)CookieHelper.putAndMergeCookie(cookiesObject, (Cookie[])null);
        Assert.assertSame(cookiesObject, (Object)unModifiedCookiesObject);
        Assert.assertEquals((long)2L, (long)cookiesObject.size());
    }

    @Test
    public void testPutAndMergeCookieObjectCookieArray_CookiesInArray_NewCookiesInArray() {
        Cookie[] cookiesObject = new Cookie[]{new Cookie(null, COOKIE_1_NAME, COOKIE_1_ORIGINAL_VALUE)};
        Assert.assertEquals((long)1L, (long)cookiesObject.length);
        Cookie[] newCookiesArray = new Cookie[]{new Cookie(null, COOKIE_1_NAME, COOKIE_1_NEW_VALUE), new Cookie(null, COOKIE_2_NAME, COOKIE_2_VALUE)};
        cookiesObject = (Cookie[])CookieHelper.putAndMergeCookie((Object)cookiesObject, (Cookie[])newCookiesArray);
        Assert.assertEquals((long)2L, (long)cookiesObject.length);
        Assert.assertEquals((Object)COOKIE_1_NAME, (Object)cookiesObject[0].getName());
        Assert.assertEquals((Object)COOKIE_1_NEW_VALUE, (Object)cookiesObject[0].getValue());
        Assert.assertEquals((Object)COOKIE_2_NAME, (Object)cookiesObject[1].getName());
        Assert.assertEquals((Object)COOKIE_2_VALUE, (Object)cookiesObject[1].getValue());
        Cookie[] unModifiedCookiesObject = (Cookie[])CookieHelper.putAndMergeCookie((Object)cookiesObject, (Cookie[])null);
        Assert.assertSame((Object)cookiesObject, (Object)unModifiedCookiesObject);
        Assert.assertEquals((long)2L, (long)cookiesObject.length);
    }

    @Test
    public void testAsArrayOfCookies_CookiesInArray() throws Exception {
        Cookie[] cookiesObject = new Cookie[]{new Cookie()};
        Assert.assertSame((Object)cookiesObject, (Object)CookieHelper.asArrayOfCookies((Object)cookiesObject));
        Cookie[] emptyArray = CookieHelper.asArrayOfCookies(null);
        Assert.assertNotNull((String)"A null cookiesObject should return a non null array", (Object)emptyArray);
        Assert.assertEquals((long)0L, (long)emptyArray.length);
    }

    @Test
    public void testAsArrayOfCookies_CookiesInMap() throws Exception {
        LinkedHashMap<String, String> cookiesObject = new LinkedHashMap<String, String>();
        cookiesObject.put(COOKIE_1_NAME, COOKIE_1_ORIGINAL_VALUE);
        cookiesObject.put(COOKIE_2_NAME, COOKIE_2_VALUE);
        Cookie[] cookiesAsArray = CookieHelper.asArrayOfCookies(cookiesObject);
        Assert.assertNotNull((String)"Array of cookies should not be null", (Object)cookiesAsArray);
        Assert.assertEquals((long)2L, (long)cookiesAsArray.length);
        Assert.assertEquals((Object)COOKIE_1_NAME, (Object)cookiesAsArray[0].getName());
        Assert.assertEquals((Object)COOKIE_1_ORIGINAL_VALUE, (Object)cookiesAsArray[0].getValue());
        Assert.assertEquals((Object)COOKIE_2_NAME, (Object)cookiesAsArray[1].getName());
        Assert.assertEquals((Object)COOKIE_2_VALUE, (Object)cookiesAsArray[1].getValue());
    }

    @Test
    public void testResolveCookieStorageType() throws Exception {
        Assert.assertSame((Object)CookieStorageType.MAP_STRING_STRING, (Object)CookieStorageType.resolveCookieStorageType(new HashMap()));
        Assert.assertSame((Object)CookieStorageType.ARRAY_OF_COOKIES, (Object)CookieStorageType.resolveCookieStorageType(null));
        Assert.assertSame((Object)CookieStorageType.ARRAY_OF_COOKIES, (Object)CookieStorageType.resolveCookieStorageType((Object)new Cookie[2]));
        try {
            CookieStorageType.resolveCookieStorageType((Object)new Object());
            Assert.fail((String)"It should have thrown an exception since Object it is not a valid type");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid cookiesObject"));
        }
    }
}

