/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.components;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.component.ComponentException;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transport.http.components.RestServiceException;

public class RestServiceWrapperFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    protected static String TEST_REQUEST = "Test Http Request";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public RestServiceWrapperFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-rest-service-wrapper-functional-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-rest-service-wrapper-functional-test-flow.xml"});
    }

    @Test
    public void testErrorExpressionOnRegexFilterFail() throws Exception {
        MuleMessage result = muleContext.getClient().send("restServiceEndpoint", (Object)TEST_REQUEST, null);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getExceptionPayload());
        Assert.assertEquals(RestServiceException.class, result.getExceptionPayload().getException().getClass());
    }

    @Test
    public void testErrorExpressionOnRegexFilterPass() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("restServiceEndpoint2", (Object)TEST_REQUEST, null);
        Assert.assertEquals((Object)("echo=" + TEST_REQUEST), (Object)result.getPayloadAsString());
    }

    @Test
    public void testRequiredParameters() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("baz-header", "baz");
        props.put("bar-optional-header", "bar");
        MuleMessage result = client.send("restServiceEndpoint3", null, props);
        Assert.assertEquals((Object)"foo=boo&faz=baz&far=bar", (Object)result.getPayloadAsString());
    }

    @Test
    public void testOptionalParametersMissing() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("baz-header", "baz");
        MuleMessage result = client.send("restServiceEndpoint3", null, props);
        Assert.assertEquals((Object)"foo=boo&faz=baz", (Object)result.getPayloadAsString());
    }

    @Test
    public void testRequiredParametersMissing() throws Exception {
        HashMap props = new HashMap();
        MuleMessage result = muleContext.getClient().send("restServiceEndpoint3", null, props);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getExceptionPayload());
        Assert.assertEquals(ComponentException.class, result.getExceptionPayload().getException().getClass());
    }

    @Test
    public void testRestServiceComponentInFlow() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("vm://toFlow", (Object)TEST_REQUEST, null);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"echo=Test Http Request", (Object)result.getPayloadAsString());
    }
}

