/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpMethodTestCase
extends AbstractServiceAndFlowTestCase {
    private HttpMethodBase method;
    private MuleClient muleClient = null;
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    public HttpMethodTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "http-method-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "http-method-test-flow.xml"});
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.muleClient = new MuleClient(muleContext);
    }

    @Test
    public void testHead() throws Exception {
        HttpClient client = new HttpClient();
        this.method = new HeadMethod(((InboundEndpoint)this.muleClient.getMuleContext().getRegistry().lookupObject("inHttpIn")).getAddress());
        int statusCode = client.executeMethod((HttpMethod)this.method);
        Assert.assertEquals((Object)Integer.toString(200), (Object)Integer.toString(statusCode));
    }

    @Test
    public void testOptions() throws Exception {
        HttpClient client = new HttpClient();
        this.method = new OptionsMethod(((InboundEndpoint)this.muleClient.getMuleContext().getRegistry().lookupObject("inHttpIn")).getAddress());
        int statusCode = client.executeMethod((HttpMethod)this.method);
        Assert.assertEquals((Object)Integer.toString(200), (Object)Integer.toString(statusCode));
    }

    @Test
    public void testPut() throws Exception {
        HttpClient client = new HttpClient();
        this.method = new PutMethod(((InboundEndpoint)this.muleClient.getMuleContext().getRegistry().lookupObject("inHttpIn")).getAddress());
        int statusCode = client.executeMethod((HttpMethod)this.method);
        Assert.assertEquals((Object)Integer.toString(200), (Object)Integer.toString(statusCode));
    }

    @Test
    public void testDelete() throws Exception {
        HttpClient client = new HttpClient();
        this.method = new DeleteMethod(((InboundEndpoint)this.muleClient.getMuleContext().getRegistry().lookupObject("inHttpIn")).getAddress());
        int statusCode = client.executeMethod((HttpMethod)this.method);
        Assert.assertEquals((Object)Integer.toString(200), (Object)Integer.toString(statusCode));
    }

    @Test
    public void testTrace() throws Exception {
        HttpClient client = new HttpClient();
        this.method = new TraceMethod(((InboundEndpoint)this.muleClient.getMuleContext().getRegistry().lookupObject("inHttpIn")).getAddress());
        int statusCode = client.executeMethod((HttpMethod)this.method);
        Assert.assertEquals((Object)Integer.toString(200), (Object)Integer.toString(statusCode));
    }

    @Test
    public void testConnect() throws Exception {
        HttpClient client = new HttpClient();
        this.method = new HttpMethodBase(((InboundEndpoint)this.muleClient.getMuleContext().getRegistry().lookupObject("inHttpIn")).getAddress()){

            public String getName() {
                return "CONNECT";
            }
        };
        int statusCode = client.executeMethod((HttpMethod)this.method);
        Assert.assertEquals((Object)Integer.toString(200), (Object)Integer.toString(statusCode));
    }

    @Test
    public void testFoo() throws Exception {
        HttpClient client = new HttpClient();
        this.method = new HttpMethodBase(((InboundEndpoint)this.muleClient.getMuleContext().getRegistry().lookupObject("inHttpIn")).getAddress()){

            public String getName() {
                return "FOO";
            }
        };
        int statusCode = client.executeMethod((HttpMethod)this.method);
        Assert.assertEquals((Object)Integer.toString(400), (Object)Integer.toString(statusCode));
    }
}

