/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.functional;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.ClassUtils;

public class StaticResourcesMPFunctionalTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");
    @Rule
    public DynamicPort port2 = new DynamicPort("port2");

    public StaticResourcesMPFunctionalTestCase() {
        System.setProperty("test.root", ClassUtils.getClassPathRoot(StaticResourcesMPFunctionalTestCase.class).getPath());
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
    }

    protected String getConfigResources() {
        return "http-static-resource-test.xml";
    }

    @Test
    public void testHttpStaticResource() throws Exception {
        String url = String.format("http://localhost:%1d/static", this.port1.getNumber());
        GetMethod method = new GetMethod(url);
        HttpClient client = new HttpClient();
        int responseCode = client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)200L, (long)responseCode);
        String result = method.getResponseBodyAsString();
        Assert.assertEquals((Object)result, (Object)"Test index.html");
        method = new GetMethod(url + "/main.html");
        responseCode = client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)200L, (long)responseCode);
        result = method.getResponseBodyAsString();
        Assert.assertEquals((Object)result, (Object)"Test main.html");
        method = new GetMethod(url + "/foo.html");
        responseCode = client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)404L, (long)responseCode);
    }

    @Test
    public void testHttpStaticResourceMimeTypes() throws Exception {
        String url = String.format("http://localhost:%1d/static", this.port1.getNumber());
        GetMethod method = new GetMethod(url);
        HttpClient client = new HttpClient();
        int responseCode = client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)200L, (long)responseCode);
        String result = method.getResponseBodyAsString();
        Assert.assertEquals((Object)result, (Object)"Test index.html");
        Assert.assertEquals((Object)"text/html", (Object)method.getResponseHeader("Content-Type").getValue());
        method = new GetMethod(url + "/image.gif");
        responseCode = client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)200L, (long)responseCode);
        Assert.assertEquals((Object)"image/gif", (Object)method.getResponseHeader("Content-Type").getValue());
        method = new GetMethod(url + "/image.png");
        responseCode = client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)200L, (long)responseCode);
        Assert.assertEquals((Object)"image/png", (Object)method.getResponseHeader("Content-Type").getValue());
    }

    @Test
    public void testHttpsStaticResource() throws Exception {
        String url = String.format("https://localhost:%2d/static", this.port2.getNumber());
        GetMethod method = new GetMethod(url);
        HttpClient client = new HttpClient();
        int responseCode = client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)200L, (long)responseCode);
        String result = method.getResponseBodyAsString();
        Assert.assertEquals((Object)result, (Object)"Test index.html");
        method = new GetMethod(url + "/main.html");
        responseCode = client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)200L, (long)responseCode);
        result = method.getResponseBodyAsString();
        Assert.assertEquals((Object)result, (Object)"Test main.html");
        method = new GetMethod(url + "/foo.html");
        responseCode = client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)404L, (long)responseCode);
    }

    @Test
    public void testFlowBindingOnSamePort() throws Exception {
        String url = String.format("http://localhost:%1d/echo", this.port1.getNumber());
        GetMethod method = new GetMethod(url);
        HttpClient client = new HttpClient();
        int responseCode = client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)200L, (long)responseCode);
        Assert.assertEquals((Object)method.getResponseBodyAsString(), (Object)"/echo");
        url = String.format("https://localhost:%2d/echo", this.port2.getNumber());
        method = new GetMethod(url);
        responseCode = client.executeMethod((HttpMethod)method);
        Assert.assertEquals((long)200L, (long)responseCode);
        Assert.assertEquals((Object)method.getResponseBodyAsString(), (Object)"/echo");
    }
}

