/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.reliability;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.ExceptionPayload;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.exception.RollbackSourceCallback;
import org.mule.exception.AbstractMessagingExceptionStrategy;
import org.mule.exception.DefaultSystemExceptionStrategy;
import org.mule.message.DefaultExceptionPayload;
import org.mule.routing.filters.WildcardFilter;
import org.mule.tck.DynamicPortTestCase;
import org.mule.transport.NullPayload;

public class InboundMessageLossTestCase
extends DynamicPortTestCase {
    protected HttpClient httpClient = new HttpClient();

    protected String getConfigResources() {
        return "reliability/inbound-message-loss.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        ((DefaultSystemExceptionStrategy)muleContext.getExceptionListener()).setRollbackTxFilter(new WildcardFilter("*"));
    }

    public void testNoException() throws Exception {
        HttpMethodBase request = this.createRequest(this.getBaseUri() + "/noException");
        int status = this.httpClient.executeMethod((HttpMethod)request);
        InboundMessageLossTestCase.assertEquals((int)200, (int)status);
        InboundMessageLossTestCase.assertEquals((String)"Here you go", (String)request.getResponseBodyAsString());
    }

    public void testTransformerException() throws Exception {
        HttpMethodBase request = this.createRequest(this.getBaseUri() + "/transformerException");
        int status = this.httpClient.executeMethod((HttpMethod)request);
        InboundMessageLossTestCase.assertEquals((int)500, (int)status);
        InboundMessageLossTestCase.assertTrue((boolean)request.getResponseBodyAsString().contains("Failure"));
    }

    public void testHandledTransformerException() throws Exception {
        HttpMethodBase request = this.createRequest(this.getBaseUri() + "/handledTransformerException");
        int status = this.httpClient.executeMethod((HttpMethod)request);
        InboundMessageLossTestCase.assertEquals((int)200, (int)status);
        InboundMessageLossTestCase.assertTrue((boolean)request.getResponseBodyAsString().contains("Success"));
    }

    public void testNotHandledTransformerException() throws Exception {
        HttpMethodBase request = this.createRequest(this.getBaseUri() + "/notHandledTransformerException");
        int status = this.httpClient.executeMethod((HttpMethod)request);
        InboundMessageLossTestCase.assertEquals((int)500, (int)status);
        InboundMessageLossTestCase.assertTrue((boolean)request.getResponseBodyAsString().contains("Bad news"));
    }

    public void testRouterException() throws Exception {
        HttpMethodBase request = this.createRequest(this.getBaseUri() + "/routerException");
        int status = this.httpClient.executeMethod((HttpMethod)request);
        InboundMessageLossTestCase.assertEquals((int)500, (int)status);
        InboundMessageLossTestCase.assertTrue((boolean)request.getResponseBodyAsString().contains("Failure"));
    }

    public void testComponentException() throws Exception {
        HttpMethodBase request = this.createRequest(this.getBaseUri() + "/componentException");
        int status = this.httpClient.executeMethod((HttpMethod)request);
        InboundMessageLossTestCase.assertEquals((int)500, (int)status);
        InboundMessageLossTestCase.assertTrue((boolean)request.getResponseBodyAsString().contains("exception"));
    }

    protected HttpMethodBase createRequest(String uri) {
        return new GetMethod(uri);
    }

    protected String getBaseUri() {
        return "http://localhost:" + this.getPorts().get(0);
    }

    protected int getNumPortsToFind() {
        return 1;
    }

    public static class BadHandler
    extends AbstractMessagingExceptionStrategy {
        public BadHandler(MuleContext muleContext) {
            super(muleContext);
        }

        public MuleEvent handleException(Exception ex, MuleEvent event, RollbackSourceCallback rollbackMethod) {
            this.doHandleException(ex, event, rollbackMethod);
            DefaultMuleMessage message = new DefaultMuleMessage((Object)NullPayload.getInstance(), this.muleContext);
            message.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new MessagingException(event, (Throwable)new RuntimeException("Bad news!"))));
            return new DefaultMuleEvent((MuleMessage)message, event);
        }
    }

    public static class Handler
    extends AbstractMessagingExceptionStrategy {
        public Handler(MuleContext muleContext) {
            super(muleContext);
        }

        public MuleEvent handleException(Exception ex, MuleEvent event, RollbackSourceCallback rollbackMethod) {
            this.doHandleException(ex, event, rollbackMethod);
            return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"Success!", this.muleContext), event);
        }
    }
}

