/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.module.client.MuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class DispatchTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigResources() {
        return "dispatch-conf.xml";
    }

    @Test
    public void testEchoService() throws Exception {
        int THREADS = 10;
        final CountDownLatch latch = new CountDownLatch(10);
        final MuleClient client = new MuleClient(muleContext);
        final byte[] buf = new byte[8192];
        Arrays.fill(buf, (byte)97);
        client.send(((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject("inEchoService")).getAddress(), (MuleMessage)new DefaultMuleMessage((Object)new ByteArrayInputStream(buf), muleContext));
        for (int i = 0; i < 10; ++i) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HashMap<String, String> props = new HashMap<String, String>();
                    props.put("MULE_REPLYTO", "vm://queue");
                    try {
                        for (int j = 0; j < 20; ++j) {
                            client.dispatch(((InboundEndpoint)client.getMuleContext().getRegistry().lookupObject("inEchoService")).getAddress(), (Object)new DefaultMuleMessage((Object)buf, muleContext), props);
                        }
                    }
                    catch (MuleException e) {
                        e.printStackTrace();
                    }
                    finally {
                        latch.countDown();
                    }
                }
            }).start();
        }
        latch.await(40L, TimeUnit.SECONDS);
        int count = 0;
        while (client.request("vm://queue", 5000L) != null) {
            ++count;
        }
        Assert.assertEquals((long)200L, (long)count);
    }
}

