/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import org.junit.Assert;
import org.junit.Test;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class HttpEndpointTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testHostPortOnlyUrl() throws Exception {
        MuleEndpointURI endpointUri = new MuleEndpointURI("http://localhost:8080", muleContext);
        endpointUri.initialise();
        Assert.assertEquals((Object)"http", (Object)endpointUri.getScheme());
        Assert.assertEquals((Object)"http://localhost:8080", (Object)endpointUri.getAddress());
        Assert.assertNull((Object)endpointUri.getEndpointName());
        Assert.assertEquals((long)8080L, (long)endpointUri.getPort());
        Assert.assertEquals((Object)"localhost", (Object)endpointUri.getHost());
        Assert.assertEquals((Object)"http://localhost:8080", (Object)endpointUri.getAddress());
        Assert.assertEquals((long)0L, (long)endpointUri.getParams().size());
    }

    @Test
    public void testHostPortOnlyUrlAndUserInfo() throws Exception {
        MuleEndpointURI endpointUri = new MuleEndpointURI("http://admin:pwd@localhost:8080", muleContext);
        endpointUri.initialise();
        Assert.assertEquals((Object)"http", (Object)endpointUri.getScheme());
        Assert.assertEquals((Object)"http://localhost:8080", (Object)endpointUri.getAddress());
        Assert.assertNull((Object)endpointUri.getEndpointName());
        Assert.assertEquals((long)8080L, (long)endpointUri.getPort());
        Assert.assertEquals((Object)"localhost", (Object)endpointUri.getHost());
        Assert.assertEquals((Object)"http://localhost:8080", (Object)endpointUri.getAddress());
        Assert.assertEquals((long)0L, (long)endpointUri.getParams().size());
        Assert.assertEquals((Object)"admin:pwd", (Object)endpointUri.getUserInfo());
        Assert.assertEquals((Object)"admin", (Object)endpointUri.getUser());
        Assert.assertEquals((Object)"pwd", (Object)endpointUri.getPassword());
        Assert.assertEquals((Object)"http://admin:****@localhost:8080", (Object)endpointUri.toString());
    }

    @Test
    public void testHostPortAndPathUrl() throws Exception {
        MuleEndpointURI endpointUri = new MuleEndpointURI("http://localhost:8080/app/path", muleContext);
        endpointUri.initialise();
        Assert.assertEquals((Object)"http", (Object)endpointUri.getScheme());
        Assert.assertEquals((Object)"http://localhost:8080/app/path", (Object)endpointUri.getAddress());
        Assert.assertNull((Object)endpointUri.getEndpointName());
        Assert.assertEquals((long)8080L, (long)endpointUri.getPort());
        Assert.assertEquals((Object)"localhost", (Object)endpointUri.getHost());
        Assert.assertEquals((Object)"http://localhost:8080/app/path", (Object)endpointUri.getAddress());
        Assert.assertEquals((Object)endpointUri.getPath(), (Object)"/app/path");
        Assert.assertEquals((long)0L, (long)endpointUri.getParams().size());
    }

    @Test
    public void testHostPortAndPathUrlAndUserInfo() throws Exception {
        MuleEndpointURI endpointUri = new MuleEndpointURI("http://admin:pwd@localhost:8080/app/path", muleContext);
        endpointUri.initialise();
        Assert.assertEquals((Object)"http", (Object)endpointUri.getScheme());
        Assert.assertEquals((Object)"http://localhost:8080/app/path", (Object)endpointUri.getAddress());
        Assert.assertNull((Object)endpointUri.getEndpointName());
        Assert.assertEquals((long)8080L, (long)endpointUri.getPort());
        Assert.assertEquals((Object)"localhost", (Object)endpointUri.getHost());
        Assert.assertEquals((Object)"http://localhost:8080/app/path", (Object)endpointUri.getAddress());
        Assert.assertEquals((Object)endpointUri.getPath(), (Object)"/app/path");
        Assert.assertEquals((long)0L, (long)endpointUri.getParams().size());
        Assert.assertEquals((Object)"admin:pwd", (Object)endpointUri.getUserInfo());
        Assert.assertEquals((Object)"admin", (Object)endpointUri.getUser());
        Assert.assertEquals((Object)"pwd", (Object)endpointUri.getPassword());
        Assert.assertEquals((Object)"http://admin:****@localhost:8080/app/path", (Object)endpointUri.toString());
    }

    @Test
    public void testHostPortAndPathUrlUserInfoAndQuery() throws Exception {
        MuleEndpointURI endpointUri = new MuleEndpointURI("http://admin:pwd@localhost:8080/app/path?${foo}", muleContext);
        endpointUri.initialise();
        Assert.assertEquals((Object)"http", (Object)endpointUri.getScheme());
        Assert.assertEquals((Object)"http://localhost:8080/app/path?$[foo]", (Object)endpointUri.getAddress());
        Assert.assertNull((Object)endpointUri.getEndpointName());
        Assert.assertEquals((long)8080L, (long)endpointUri.getPort());
        Assert.assertEquals((Object)"localhost", (Object)endpointUri.getHost());
        Assert.assertEquals((Object)endpointUri.getPath(), (Object)"/app/path");
        Assert.assertEquals((Object)endpointUri.getQuery(), (Object)"$[foo]");
        Assert.assertEquals((long)1L, (long)endpointUri.getParams().size());
        Assert.assertEquals((Object)"admin:pwd", (Object)endpointUri.getUserInfo());
        Assert.assertEquals((Object)"admin", (Object)endpointUri.getUser());
        Assert.assertEquals((Object)"pwd", (Object)endpointUri.getPassword());
        Assert.assertEquals((Object)"http://admin:****@localhost:8080/app/path?$[foo]", (Object)endpointUri.toString());
    }
}

